/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;

class SocketCache {
    private static final Log LOG = LogFactory.getLog(SocketCache.class);
    private Daemon daemon;
    private static LinkedListMultimap<SocketAddress, SocketProp> multimap = LinkedListMultimap.create();
    private static int capacity;
    private static long expiryPeriod;
    private static SocketCache scInstance;

    SocketCache() {
    }

    private static boolean isInitedOnce() {
        return capacity != 0 && expiryPeriod != 0L;
    }

    public static synchronized SocketCache getInstance(int c, long e) {
        if (c == 0 || e == 0L) {
            throw new IllegalStateException("Cannot initialize ZERO capacity or expiryPeriod");
        }
        if (!SocketCache.isInitedOnce()) {
            capacity = c;
            expiryPeriod = e;
        } else if (capacity != c || expiryPeriod != e) {
            LOG.info((Object)("capacity and expiry periods already set to " + capacity + " and " + expiryPeriod + " respectively. Cannot set it to " + c + " and " + e));
        }
        return scInstance;
    }

    private boolean isDaemonStarted() {
        return this.daemon != null;
    }

    private synchronized void startExpiryDaemon() {
        if (this.isDaemonStarted()) {
            return;
        }
        this.daemon = new Daemon(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SocketCache.this.run();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    SocketCache.this.clear();
                }
            }

            public String toString() {
                return String.valueOf(SocketCache.this);
            }
        });
        this.daemon.start();
    }

    public synchronized Socket get(SocketAddress remote) {
        List sockPropList = multimap.get((Object)remote);
        if (sockPropList == null) {
            return null;
        }
        Iterator iter = sockPropList.iterator();
        while (iter.hasNext()) {
            Socket candidate = ((SocketProp)iter.next()).getSocket();
            iter.remove();
            if (candidate.isClosed()) continue;
            return candidate;
        }
        return null;
    }

    public synchronized void put(Socket sock) {
        Preconditions.checkNotNull((Object)sock);
        this.startExpiryDaemon();
        SocketAddress remoteAddr = sock.getRemoteSocketAddress();
        if (remoteAddr == null) {
            LOG.warn((Object)("Cannot cache (unconnected) socket with no remote address: " + sock));
            IOUtils.closeSocket((Socket)sock);
            return;
        }
        if (capacity == multimap.size()) {
            this.evictOldest();
        }
        multimap.put((Object)remoteAddr, (Object)new SocketProp(sock));
    }

    public synchronized int size() {
        return multimap.size();
    }

    private synchronized void evictExpired(long expiryPeriod) {
        Iterator iter;
        Map.Entry entry;
        while (multimap.size() != 0 && (entry = (Map.Entry)(iter = multimap.entries().iterator()).next()) != null && System.currentTimeMillis() - ((SocketProp)entry.getValue()).getCreateTime() >= expiryPeriod) {
            iter.remove();
            Socket sock = ((SocketProp)entry.getValue()).getSocket();
            IOUtils.closeSocket((Socket)sock);
        }
    }

    private synchronized void evictOldest() {
        Iterator iter = multimap.entries().iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("Cannot evict from empty cache!");
        }
        Map.Entry entry = (Map.Entry)iter.next();
        iter.remove();
        Socket sock = ((SocketProp)entry.getValue()).getSocket();
        IOUtils.closeSocket((Socket)sock);
    }

    private void run() throws InterruptedException {
        long lastExpiryTime = System.currentTimeMillis();
        while (!Thread.interrupted()) {
            long elapsed = System.currentTimeMillis() - lastExpiryTime;
            if (elapsed >= expiryPeriod) {
                this.evictExpired(expiryPeriod);
                lastExpiryTime = System.currentTimeMillis();
            }
            Thread.sleep(expiryPeriod);
        }
        this.clear();
        throw new InterruptedException("Daemon Interrupted");
    }

    private synchronized void clear() {
        for (SocketProp sockProp : multimap.values()) {
            IOUtils.closeSocket((Socket)sockProp.getSocket());
        }
        multimap.clear();
    }

    static {
        scInstance = new SocketCache();
    }

    private static class SocketProp {
        Socket s;
        long createTime;

        public SocketProp(Socket s) {
            this.s = s;
            this.createTime = System.currentTimeMillis();
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public Socket getSocket() {
            return this.s;
        }
    }
}

