/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hadoop.fs.FSInputStream;

public abstract class ByteRangeInputStream
extends FSInputStream {
    protected InputStream in;
    protected URLOpener originalURL;
    protected URLOpener resolvedURL;
    protected long startPos = 0L;
    protected long currentPos = 0L;
    protected Long fileLength = null;
    StreamStatus status = StreamStatus.SEEK;

    public ByteRangeInputStream(URLOpener o, URLOpener r) {
        this.originalURL = o;
        this.resolvedURL = r;
    }

    protected abstract void checkResponseCode(HttpURLConnection var1) throws IOException;

    protected abstract URL getResolvedUrl(HttpURLConnection var1) throws IOException;

    @VisibleForTesting
    protected InputStream getInputStream() throws IOException {
        switch (this.status) {
            case NORMAL: {
                break;
            }
            case SEEK: {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = this.openInputStream();
                this.status = StreamStatus.NORMAL;
                break;
            }
            case CLOSED: {
                throw new IOException("Stream closed");
            }
        }
        return this.in;
    }

    @VisibleForTesting
    protected InputStream openInputStream() throws IOException {
        URLOpener opener = this.resolvedURL.getURL() == null ? this.originalURL : this.resolvedURL;
        HttpURLConnection connection = opener.openConnection(this.startPos);
        connection.connect();
        this.checkResponseCode(connection);
        this.resolvedURL.setURL(this.getResolvedUrl(connection));
        InputStream in = connection.getInputStream();
        Map<String, List<String>> headers = connection.getHeaderFields();
        if (ByteRangeInputStream.isChunkedTransferEncoding(headers)) {
            this.fileLength = null;
        } else {
            String cl = connection.getHeaderField("Content-Length");
            if (cl == null) {
                throw new IOException("Content-Length is missing: " + headers);
            }
            long streamlength = Long.parseLong(cl);
            this.fileLength = this.startPos + streamlength;
            in = new BoundedInputStream(in, streamlength);
        }
        return in;
    }

    private static boolean isChunkedTransferEncoding(Map<String, List<String>> headers) {
        return ByteRangeInputStream.contains(headers, "Transfer-Encoding", "chunked") || ByteRangeInputStream.contains(headers, "TE", "chunked");
    }

    private static boolean contains(Map<String, List<String>> headers, String key, String value) {
        List<String> values = headers.get(key);
        if (values != null) {
            for (String v : values) {
                StringTokenizer t = new StringTokenizer(v, ",");
                while (t.hasMoreTokens()) {
                    if (!value.equalsIgnoreCase(t.nextToken())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private int update(int n) throws IOException {
        if (n != -1) {
            this.currentPos += (long)n;
        } else if (this.fileLength != null && this.currentPos < this.fileLength) {
            throw new IOException("Got EOF but currentPos = " + this.currentPos + " < filelength = " + this.fileLength);
        }
        return n;
    }

    public int read() throws IOException {
        int b = this.getInputStream().read();
        this.update(b == -1 ? -1 : 1);
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.update(this.getInputStream().read(b, off, len));
    }

    public void seek(long pos) throws IOException {
        if (pos != this.currentPos) {
            this.startPos = pos;
            this.currentPos = pos;
            if (this.status != StreamStatus.CLOSED) {
                this.status = StreamStatus.SEEK;
            }
        }
    }

    public long getPos() throws IOException {
        return this.currentPos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        this.status = StreamStatus.CLOSED;
    }

    static enum StreamStatus {
        NORMAL,
        SEEK,
        CLOSED;

    }

    public static abstract class URLOpener {
        protected URL url;

        public URLOpener(URL u) {
            this.url = u;
        }

        public void setURL(URL u) {
            this.url = u;
        }

        public URL getURL() {
            return this.url;
        }

        protected abstract HttpURLConnection openConnection() throws IOException;

        protected abstract HttpURLConnection openConnection(long var1) throws IOException;
    }
}

