/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.hdfs.util.CyclicIteration;

public class TestCyclicIteration
extends TestCase {
    public void testCyclicIteration() throws Exception {
        for (int n = 0; n < 5; ++n) {
            TestCyclicIteration.checkCyclicIteration(n);
        }
    }

    private static void checkCyclicIteration(int numOfElements) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        Integer[] integers = new Integer[numOfElements];
        for (int i = 0; i < integers.length; ++i) {
            integers[i] = 2 * i;
            map.put(integers[i], integers[i]);
        }
        System.out.println("\n\nintegers=" + Arrays.asList(integers));
        System.out.println("map=" + map);
        for (int start = -1; start <= 2 * integers.length - 1; ++start) {
            ArrayList iteration = new ArrayList();
            for (Map.Entry e : new CyclicIteration(map, (Object)start)) {
                iteration.add(e.getKey());
            }
            System.out.println("start=" + start + ", iteration=" + iteration);
            for (int i = 0; i < integers.length; ++i) {
                int j = ((start + 2) / 2 + i) % integers.length;
                TestCyclicIteration.assertEquals((String)("i=" + i + ", j=" + j), iteration.get(i), (Object)integers[j]);
            }
        }
    }
}

