/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.OfflineEditsViewerHelper;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.EditsVisitorFactory;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsViewer;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.StatisticsEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.Tokenizer;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.TokenizerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOfflineEditsViewer {
    private static final Log LOG = LogFactory.getLog(TestOfflineEditsViewer.class);
    private static final Map<FSEditLogOpCodes, Boolean> obsoleteOpCodes = new HashMap<FSEditLogOpCodes, Boolean>();
    private static String buildDir;
    private static String cacheDir;
    private static final OfflineEditsViewerHelper nnHelper;

    private static void initializeObsoleteOpCodes() {
        obsoleteOpCodes.put(FSEditLogOpCodes.OP_DATANODE_ADD, true);
        obsoleteOpCodes.put(FSEditLogOpCodes.OP_DATANODE_REMOVE, true);
        obsoleteOpCodes.put(FSEditLogOpCodes.OP_SET_NS_QUOTA, true);
        obsoleteOpCodes.put(FSEditLogOpCodes.OP_CLEAR_NS_QUOTA, true);
    }

    @Before
    public void setup() {
        new File(cacheDir).mkdirs();
    }

    @Test
    public void testGenerated() throws IOException {
        LOG.info((Object)"START - testing with generated edits");
        nnHelper.startCluster(buildDir + "/dfs/");
        String edits = nnHelper.generateEdits();
        String editsParsedXml = cacheDir + "/editsParsed.xml";
        String editsReparsed = cacheDir + "/editsReparsed";
        this.runOev(edits, editsParsedXml, "xml");
        this.runOev(editsParsedXml, editsReparsed, "binary");
        Assert.assertTrue((String)("Edits " + edits + " should have all op codes"), (boolean)this.hasAllOpCodes(edits));
        Assert.assertTrue((String)"Generated edits and reparsed (bin to XML to bin) should be same", (boolean)this.filesEqualIgnoreTrailingZeros(edits, editsReparsed));
        nnHelper.shutdownCluster();
        LOG.info((Object)"END");
    }

    @Test
    public void testStored() throws IOException {
        LOG.info((Object)"START - testing with stored reference edits");
        String editsStored = cacheDir + "/editsStored";
        String editsStoredParsedXml = cacheDir + "/editsStoredParsed.xml";
        String editsStoredReparsed = cacheDir + "/editsStoredReparsed";
        String editsStoredXml = cacheDir + "/editsStored.xml";
        this.runOev(editsStored, editsStoredParsedXml, "xml");
        this.runOev(editsStoredParsedXml, editsStoredReparsed, "binary");
        Assert.assertTrue((String)("Edits " + editsStored + " should have all op codes"), (boolean)this.hasAllOpCodes(editsStored));
        Assert.assertTrue((String)"Reference XML edits and parsed to XML should be same", (boolean)this.filesEqual(editsStoredXml, editsStoredParsedXml));
        Assert.assertTrue((String)"Reference edits and reparsed (bin to XML to bin) should be same", (boolean)this.filesEqualIgnoreTrailingZeros(editsStored, editsStoredReparsed));
        LOG.info((Object)"END");
    }

    private void runOev(String inFilename, String outFilename, String processor) throws IOException {
        LOG.info((Object)("Running oev [" + inFilename + "] [" + outFilename + "]"));
        OfflineEditsViewer oev = new OfflineEditsViewer();
        oev.go(EditsVisitorFactory.getEditsVisitor((String)outFilename, (String)processor, (Tokenizer)TokenizerFactory.getTokenizer((String)inFilename), (boolean)false));
    }

    private boolean hasAllOpCodes(String inFilename) throws IOException {
        String outFilename = inFilename + ".stats";
        StatisticsEditsVisitor visitor = (StatisticsEditsVisitor)EditsVisitorFactory.getEditsVisitor((String)outFilename, (String)"stats", (Tokenizer)TokenizerFactory.getTokenizer((String)inFilename), (boolean)false);
        OfflineEditsViewer oev = new OfflineEditsViewer();
        oev.go((EditsVisitor)visitor);
        LOG.info((Object)("Statistics for " + inFilename + "\n" + visitor.getStatisticsString()));
        boolean hasAllOpCodes = true;
        for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
            Long count;
            if (obsoleteOpCodes.containsKey(opCode) || (count = (Long)visitor.getStatistics().get(opCode)) != null && count != 0L) continue;
            hasAllOpCodes = false;
            LOG.info((Object)("Opcode " + opCode + " not tested in " + inFilename));
        }
        return hasAllOpCodes;
    }

    private boolean filesEqualIgnoreTrailingZeros(String filenameSmall, String filenameLarge) throws IOException {
        ByteBuffer small = ByteBuffer.wrap(DFSTestUtil.loadFile(filenameSmall));
        ByteBuffer large = ByteBuffer.wrap(DFSTestUtil.loadFile(filenameLarge));
        if (small.capacity() > large.capacity()) {
            ByteBuffer tmpByteBuffer = small;
            small = large;
            large = tmpByteBuffer;
            String tmpFilename = filenameSmall;
            filenameSmall = filenameLarge;
            filenameLarge = tmpFilename;
        }
        small.position(0);
        small.limit(small.capacity());
        large.position(0);
        large.limit(small.capacity());
        if (!small.equals(large)) {
            return false;
        }
        large.clear();
        for (int i = large.limit(); i < large.capacity(); ++i) {
            if (large.get(i) == FSEditLogOpCodes.OP_INVALID.getOpCode()) continue;
            return false;
        }
        return true;
    }

    private boolean filesEqual(String filename1, String filename2) throws IOException {
        ByteBuffer bb1 = ByteBuffer.wrap(DFSTestUtil.loadFile(filename1));
        ByteBuffer bb2 = ByteBuffer.wrap(DFSTestUtil.loadFile(filename2));
        bb1.position(0);
        bb1.limit(bb1.capacity());
        bb2.position(0);
        bb2.limit(bb2.capacity());
        return bb1.equals(bb2);
    }

    static {
        TestOfflineEditsViewer.initializeObsoleteOpCodes();
        buildDir = System.getProperty("test.build.data", "build/test/data");
        cacheDir = System.getProperty("test.cache.data", "build/test/cache");
        nnHelper = new OfflineEditsViewerHelper();
    }
}

