/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;

public class TestStartup
extends TestCase {
    public static final String NAME_NODE_HOST = "localhost:";
    public static final String WILDCARD_HTTP_HOST = "0.0.0.0:";
    private static final Log LOG = LogFactory.getLog((String)TestStartup.class.getName());
    private Configuration config;
    private File hdfsDir = null;
    static final long seed = 0xAAAAEEFL;
    static final int blockSize = 4096;
    static final int fileSize = 8192;
    private long editsLength = 0L;
    private long fsimageLength = 0L;

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 4096L);
        byte[] buffer = new byte[8192];
        Random rand = new Random(0xAAAAEEFL);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    protected void setUp() throws Exception {
        this.config = new HdfsConfiguration();
        this.hdfsDir = new File(MiniDFSCluster.getBaseDirectory());
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory '" + this.hdfsDir + "'");
        }
        LOG.info((Object)("--hdfsdir is " + this.hdfsDir.getAbsolutePath()));
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.datanode.data.dir", new File(this.hdfsDir, "data").getPath());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "secondary")).toString());
        this.config.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
    }

    public void tearDown() throws Exception {
        if (this.hdfsDir.exists() && !FileUtil.fullyDelete((File)this.hdfsDir)) {
            throw new IOException("Could not delete hdfs directory in tearDown '" + this.hdfsDir + "'");
        }
    }

    public void createCheckPoint() throws IOException {
        LOG.info((Object)"--starting mini cluster");
        MiniDFSCluster cluster = null;
        SecondaryNameNode sn = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.config).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
            cluster.waitActive();
            LOG.info((Object)"--starting Secondary Node");
            sn = new SecondaryNameNode(this.config);
            TestStartup.assertNotNull((Object)sn);
            FileSystem fileSys = cluster.getFileSystem();
            Path file1 = new Path("t1");
            this.writeFile(fileSys, file1, 1);
            LOG.info((Object)"--doing checkpoint");
            sn.doCheckpoint();
            LOG.info((Object)"--done checkpoint");
        }
        catch (IOException e) {
            TestStartup.fail((String)StringUtils.stringifyException((Throwable)e));
            System.err.println("checkpoint failed");
            throw e;
        }
        finally {
            if (sn != null) {
                sn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
            LOG.info((Object)"--file t1 created, cluster shutdown");
        }
    }

    private void corruptNameNodeFiles() throws IOException {
        List nameDirs = (List)FSNamesystem.getNamespaceDirs((Configuration)this.config);
        List nameEditsDirs = (List)FSNamesystem.getNamespaceEditsDirs((Configuration)this.config);
        File dir = new File(((URI)nameDirs.get(0)).getPath());
        this.fsimageLength = new File(new File(dir, "current"), NNStorage.NameNodeFile.IMAGE.getName()).length();
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Cannot remove directory: " + dir);
        }
        LOG.info((Object)("--removed dir " + dir + ";len was =" + this.fsimageLength));
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        dir = new File(((URI)nameEditsDirs.get(0)).getPath());
        this.editsLength = new File(new File(dir, "current"), NNStorage.NameNodeFile.EDITS.getName()).length();
        if (dir.exists() && !FileUtil.fullyDelete((File)dir)) {
            throw new IOException("Cannot remove directory: " + dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        LOG.info((Object)("--removed dir and recreated " + dir + ";len was =" + this.editsLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNameNodeFiles() throws IOException {
        LOG.info((Object)"-- about to start DFS cluster");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.config).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.IMPORT).build();
            cluster.waitActive();
            LOG.info((Object)"--NN started with checkpoint option");
            NameNode nn = cluster.getNameNode();
            TestStartup.assertNotNull((Object)nn);
            FSImage image = nn.getFSImage();
            this.verifyDifferentDirs(image, this.fsimageLength, this.editsLength);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void verifyDifferentDirs(FSImage img, long expectedImgSize, long expectedEditsSize) {
        Storage.StorageDirectory sd = null;
        Iterator it = img.getStorage().dirIterator();
        while (it.hasNext()) {
            sd = (Storage.StorageDirectory)it.next();
            if (sd.getStorageDirType().isOfType((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE)) {
                img.getStorage();
                File imf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.IMAGE, (long)0L);
                LOG.info((Object)("--image file " + imf.getAbsolutePath() + "; len = " + imf.length() + "; expected = " + expectedImgSize));
                TestStartup.assertEquals((long)expectedImgSize, (long)imf.length());
                continue;
            }
            if (sd.getStorageDirType().isOfType((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
                img.getStorage();
                File edf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.EDITS, (long)0L);
                LOG.info((Object)("-- edits file " + edf.getAbsolutePath() + "; len = " + edf.length() + "; expected = " + expectedEditsSize));
                TestStartup.assertEquals((long)expectedEditsSize, (long)edf.length());
                continue;
            }
            TestStartup.fail((String)"Image/Edits directories are not different");
        }
    }

    public void testChkpointStartup2() throws IOException {
        LOG.info((Object)"--starting checkpointStartup2 - same directory for checkpoint");
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "edits")).toString());
        this.config.set("dfs.namenode.checkpoint.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        this.createCheckPoint();
        this.corruptNameNodeFiles();
        this.checkNameNodeFiles();
    }

    public void testChkpointStartup1() throws IOException {
        LOG.info((Object)"--starting testStartup Recovery");
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "edits")).toString());
        this.config.set("dfs.namenode.checkpoint.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt_edits")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        this.createCheckPoint();
        this.corruptNameNodeFiles();
        this.checkNameNodeFiles();
    }

    public void testSNNStartup() throws IOException {
        LOG.info((Object)"--starting SecondNN startup test");
        this.config.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "name")).toString());
        this.config.set("dfs.namenode.checkpoint.edits.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt_edits")).toString());
        this.config.set("dfs.namenode.checkpoint.dir", Util.fileAsURI((File)new File(this.hdfsDir, "chkpt")).toString());
        LOG.info((Object)"--starting NN ");
        MiniDFSCluster cluster = null;
        SecondaryNameNode sn = null;
        NameNode nn = null;
        try {
            cluster = new MiniDFSCluster.Builder(this.config).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
            cluster.waitActive();
            nn = cluster.getNameNode();
            TestStartup.assertNotNull((Object)nn);
            LOG.info((Object)"--starting SecondNN");
            sn = new SecondaryNameNode(this.config);
            TestStartup.assertNotNull((Object)sn);
            LOG.info((Object)"--doing checkpoint");
            sn.doCheckpoint();
            LOG.info((Object)"--done checkpoint");
            FSImage image = nn.getFSImage();
            Storage.StorageDirectory sd = image.getStorage().getStorageDir(0);
            TestStartup.assertEquals((Object)sd.getStorageDirType(), (Object)NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
            image.getStorage();
            File imf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.IMAGE, (long)0L);
            image.getStorage();
            File edf = NNStorage.getStorageFile((Storage.StorageDirectory)sd, (NNStorage.NameNodeFile)NNStorage.NameNodeFile.EDITS, (long)0L);
            LOG.info((Object)("--image file " + imf.getAbsolutePath() + "; len = " + imf.length()));
            LOG.info((Object)("--edits file " + edf.getAbsolutePath() + "; len = " + edf.length()));
            FSImage chkpImage = sn.getFSImage();
            this.verifyDifferentDirs(chkpImage, imf.length(), edf.length());
        }
        catch (IOException e) {
            TestStartup.fail((String)StringUtils.stringifyException((Throwable)e));
            System.err.println("checkpoint failed");
            throw e;
        }
        finally {
            if (sn != null) {
                sn.shutdown();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCompression() throws IOException {
        LOG.info((Object)"Test compressing image.");
        Configuration conf = new Configuration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "127.0.0.1:0");
        File base_dir = new File(System.getProperty("test.build.data", "build/test/data"), "dfs/");
        conf.set("dfs.namenode.name.dir", new File(base_dir, "name").getPath());
        conf.setBoolean("dfs.permissions.enabled", false);
        DFSTestUtil.formatNameNode(conf);
        LOG.info((Object)"Create an uncompressed fsimage");
        NameNode namenode = new NameNode(conf);
        namenode.getNamesystem().mkdirs("/test", new PermissionStatus("hairong", null, FsPermission.getDefault()), true);
        NamenodeProtocols nnRpc = namenode.getRpcServer();
        TestStartup.assertTrue((boolean)nnRpc.getFileInfo("/test").isDir());
        nnRpc.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        nnRpc.saveNamespace();
        namenode.stop();
        namenode.join();
        LOG.info((Object)"Read an uncomressed image and store it compressed using default codec.");
        conf.setBoolean("dfs.image.compress", true);
        this.checkNameSpace(conf);
        LOG.info((Object)"Read a compressed image and store it using a different codec.");
        conf.set("dfs.image.compression.codec", "org.apache.hadoop.io.compress.GzipCodec");
        this.checkNameSpace(conf);
        LOG.info((Object)"Read an compressed iamge and store it as uncompressed.");
        conf.setBoolean("dfs.image.compress", false);
        this.checkNameSpace(conf);
        LOG.info((Object)"Read an uncompressed image and store it as uncompressed.");
        this.checkNameSpace(conf);
    }

    private void checkNameSpace(Configuration conf) throws IOException {
        NameNode namenode = new NameNode(conf);
        NamenodeProtocols nnRpc = namenode.getRpcServer();
        TestStartup.assertTrue((boolean)nnRpc.getFileInfo("/test").isDir());
        nnRpc.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        nnRpc.saveNamespace();
        namenode.stop();
        namenode.join();
    }

    public void testImageChecksum() throws Exception {
        LOG.info((Object)"Test uncompressed image checksum");
        this.testImageChecksum(false);
        LOG.info((Object)"Test compressed image checksum");
        this.testImageChecksum(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testImageChecksum(boolean compress) throws Exception {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        if (compress) {
            conf.setBoolean("dfs.image.compression.codec", true);
        }
        try {
            LOG.info((Object)"\n===========================================\nStarting empty cluster");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            fs.mkdirs(new Path("/test"));
            File nameDir = new File(cluster.getNameDirs(0).iterator().next().getPath());
            File dfsDir = nameDir.getParentFile();
            TestStartup.assertEquals((String)dfsDir.getName(), (String)"dfs");
            LOG.info((Object)"Shutting down cluster #1");
            cluster.shutdown();
            cluster = null;
            File imageFile = new File(nameDir, "current/" + NNStorage.getImageFileName((long)0L));
            MD5FileUtils.saveMD5File((File)imageFile, (MD5Hash)new MD5Hash(new byte[16]));
            LOG.info((Object)"\n===========================================\nStarting same cluster after simulated crash");
            try {
                cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
                TestStartup.fail((String)"Should not have successfully started with corrupt image");
            }
            catch (IOException ioe) {
                if (!ioe.getCause().getMessage().contains("is corrupt with MD5")) {
                    throw ioe;
                }
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testNNRestart() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        int HEARTBEAT_INTERVAL = 1;
        LocalFileSystem localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = localFileSys.getWorkingDirectory();
        Path dir = new Path(workingDir, "build/test/data/work-dir/restartnn");
        Path hostsFile = new Path(dir, "hosts");
        Path excludeFile = new Path(dir, "exclude");
        conf.set("dfs.hosts.exclude", excludeFile.toUri().getPath());
        this.writeConfigFile((FileSystem)localFileSys, excludeFile, null);
        conf.set("dfs.hosts", hostsFile.toUri().getPath());
        ArrayList<String> list = new ArrayList<String>();
        byte[] b = new byte[]{127, 0, 0, 1};
        InetAddress inetAddress = InetAddress.getByAddress(b);
        list.add(inetAddress.getHostName());
        this.writeConfigFile((FileSystem)localFileSys, hostsFile, list);
        int numNameNodes = 1;
        int numDatanodes = 1;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numNameNodes(numNameNodes).numDataNodes(numDatanodes).setupHostsFile(true).build();
            cluster.waitActive();
            cluster.restartNameNode();
            NamenodeProtocols nn = cluster.getNameNodeRpc();
            TestStartup.assertNotNull((Object)nn);
            Assert.assertTrue((boolean)cluster.isDataNodeUp());
            DatanodeInfo[] info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            for (int i = 0; i < 5 && info.length != numDatanodes; ++i) {
                Thread.sleep(HEARTBEAT_INTERVAL * 1000);
                info = nn.getDatanodeReport(HdfsConstants.DatanodeReportType.LIVE);
            }
            TestStartup.assertEquals((String)("Number of live nodes should be " + numDatanodes), (int)numDatanodes, (int)info.length);
        }
        catch (IOException e) {
            TestStartup.fail((String)StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        finally {
            this.cleanupFile((FileSystem)localFileSys, excludeFile.getParent());
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void writeConfigFile(FileSystem localFileSys, Path name, ArrayList<String> nodes) throws IOException {
        if (localFileSys.exists(name)) {
            localFileSys.delete(name, true);
        }
        if (nodes != null) {
            FSDataOutputStream stm = localFileSys.create(name);
            for (String node : nodes) {
                stm.writeBytes(node);
                stm.writeBytes("\n");
            }
            stm.close();
        }
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestStartup.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        TestStartup.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }
}

