/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class TestSecurityTokenEditLog
extends TestCase {
    static final int NUM_DATA_NODES = 1;
    static final int NUM_TRANSACTIONS = 100;
    static final int NUM_THREADS = 100;
    static final int opsPerTrans = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditLog() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FileSystem fileSys = null;
        try {
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            Iterator<URI> it = cluster.getNameDirs(0).iterator();
            while (it.hasNext()) {
                File dir = new File(it.next().getPath());
                System.out.println(dir);
            }
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            editLog.setOutputBufferCapacity(2048);
            namesystem.getDelegationTokenSecretManager().startThreads();
            Thread[] threadId = new Thread[100];
            for (i = 0; i < 100; ++i) {
                Transactions trans = new Transactions(namesystem, 100);
                threadId[i] = new Thread((Runnable)trans, "TransactionThread-" + i);
                threadId[i].start();
            }
            for (i = 0; i < 100; ++i) {
                try {
                    threadId[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
            editLog.close();
            namesystem.getDelegationTokenSecretManager().stopThreads();
            int numKeys = namesystem.getDelegationTokenSecretManager().getNumberOfKeys();
            int expectedTransactions = 30000 + numKeys + 2;
            for (Storage.StorageDirectory sd : fsimage.getStorage().dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) {
                File editFile = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)sd, (long)1L, (long)(1 + expectedTransactions - 1));
                System.out.println("Verifying file: " + editFile);
                FSEditLogLoader loader = new FSEditLogLoader(namesystem);
                int numEdits = loader.loadFSEdits((EditLogInputStream)new EditLogFileInputStream(editFile), 1L);
                TestSecurityTokenEditLog.assertEquals((String)("Verification for " + editFile), (int)expectedTransactions, (int)numEdits);
            }
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static class Transactions
    implements Runnable {
        FSNamesystem namesystem;
        int numTransactions;
        short replication = (short)3;
        long blockSize = 64L;

        Transactions(FSNamesystem ns, int num) {
            this.namesystem = ns;
            this.numTransactions = num;
        }

        @Override
        public void run() {
            FSEditLog editLog = this.namesystem.getEditLog();
            for (int i = 0; i < this.numTransactions; ++i) {
                try {
                    String renewer = UserGroupInformation.getLoginUser().getUserName();
                    Token token = this.namesystem.getDelegationToken(new Text(renewer));
                    this.namesystem.renewDelegationToken(token);
                    this.namesystem.cancelDelegationToken(token);
                    editLog.logSync();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Transaction " + i + " encountered exception " + e);
                }
            }
        }
    }
}

