/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestSaveNamespace {
    private static final Log LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNamespaceWithInjectedFault(Fault fault) throws Exception {
        FSImage spyImage;
        NNStorage spyStorage;
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = new FSNamesystem(conf);
        FSImage originalImage = fsn.dir.fsImage;
        NNStorage storage = originalImage.getStorage();
        originalImage.storage = spyStorage = (NNStorage)Mockito.spy((Object)storage);
        fsn.dir.fsImage = spyImage = (FSImage)Mockito.spy((Object)originalImage);
        boolean shouldFail = false;
        switch (fault) {
            case SAVE_SECOND_FSIMAGE_RTE: {
                ((FSImage)Mockito.doAnswer((Answer)new FaultySaveImage(true)).when((Object)spyImage)).saveFSImage((Storage.StorageDirectory)Matchers.anyObject(), Matchers.anyLong());
                shouldFail = false;
                break;
            }
            case SAVE_SECOND_FSIMAGE_IOE: {
                ((FSImage)Mockito.doAnswer((Answer)new FaultySaveImage(false)).when((Object)spyImage)).saveFSImage((Storage.StorageDirectory)Matchers.anyObject(), Matchers.anyLong());
                shouldFail = false;
                break;
            }
            case SAVE_ALL_FSIMAGES: {
                ((FSImage)Mockito.doThrow((Throwable)new RuntimeException("Injected")).when((Object)spyImage)).saveFSImage((Storage.StorageDirectory)Matchers.anyObject(), Matchers.anyLong());
                shouldFail = true;
                break;
            }
            case WRITE_STORAGE_ALL: {
                ((NNStorage)Mockito.doThrow((Throwable)new RuntimeException("Injected")).when((Object)spyStorage)).writeAll();
                shouldFail = true;
                break;
            }
            case WRITE_STORAGE_ONE: {
                ((NNStorage)Mockito.doAnswer((Answer)new FaultySaveImage(true)).when((Object)spyStorage)).writeProperties((Storage.StorageDirectory)Matchers.anyObject());
                shouldFail = true;
            }
        }
        try {
            this.doAnEdit(fsn, 1);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                fsn.saveNamespace();
                if (shouldFail) {
                    Assert.fail((String)"Did not fail!");
                }
            }
            catch (Exception e) {
                if (!shouldFail) {
                    throw e;
                }
                LOG.info((Object)"Test caught expected exception", (Throwable)e);
            }
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            this.doAnEdit(fsn, 2);
            originalImage.close();
            fsn.close();
            fsn = null;
            fsn = new FSNamesystem(conf);
            this.checkEditExists(fsn, 1);
            this.checkEditExists(fsn, 2);
        }
        finally {
            if (fsn != null) {
                fsn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReinsertnamedirsInSavenamespace() throws Exception {
        FSImage spyImage;
        Configuration conf = this.getConf();
        conf.setBoolean("dfs.namenode.name.dir.restore", true);
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = new FSNamesystem(conf);
        FSImage originalImage = fsn.dir.fsImage;
        NNStorage storage = originalImage.getStorage();
        fsn.dir.fsImage = spyImage = (FSImage)Mockito.spy((Object)originalImage);
        File rootDir = storage.getStorageDir(0).getRoot();
        rootDir.setExecutable(false);
        rootDir.setWritable(false);
        rootDir.setReadable(false);
        try {
            this.doAnEdit(fsn, 1);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            LOG.info((Object)"Doing the first savenamespace.");
            fsn.saveNamespace();
            LOG.info((Object)"First savenamespace sucessful.");
            Assert.assertTrue((String)("Savenamespace should have marked one directory as bad. But found " + storage.getRemovedStorageDirs().size() + " bad directories."), (storage.getRemovedStorageDirs().size() == 1 ? 1 : 0) != 0);
            rootDir.setExecutable(true);
            rootDir.setWritable(true);
            rootDir.setReadable(true);
            LOG.info((Object)"Doing the second savenamespace.");
            fsn.saveNamespace();
            LOG.warn((Object)"Second savenamespace sucessful.");
            Assert.assertTrue((String)("Savenamespace should have been successful in removing  bad directories from Image. But found " + storage.getRemovedStorageDirs().size() + " bad directories."), (storage.getRemovedStorageDirs().size() == 0 ? 1 : 0) != 0);
            LOG.info((Object)"Shutting down fsimage.");
            originalImage.close();
            fsn.close();
            fsn = null;
            LOG.info((Object)"Loading new FSmage from disk.");
            fsn = new FSNamesystem(conf);
            LOG.info((Object)"Checking reloaded image.");
            this.checkEditExists(fsn, 1);
            LOG.info((Object)"Reloaded image is good.");
        }
        finally {
            if (rootDir.exists()) {
                rootDir.setExecutable(true);
                rootDir.setWritable(true);
                rootDir.setReadable(true);
            }
            if (fsn != null) {
                try {
                    fsn.close();
                }
                catch (Throwable t) {
                    LOG.fatal((Object)"Failed to shut down", t);
                }
            }
        }
    }

    @Test
    public void testRTEWhileSavingSecondImage() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.SAVE_SECOND_FSIMAGE_RTE);
    }

    @Test
    public void testIOEWhileSavingSecondImage() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.SAVE_SECOND_FSIMAGE_IOE);
    }

    @Test
    public void testCrashInAllImageDirs() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.SAVE_ALL_FSIMAGES);
    }

    @Test
    public void testCrashWhenWritingVersionFiles() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.WRITE_STORAGE_ALL);
    }

    @Test
    public void testCrashWhenWritingVersionFileInOneDir() throws Exception {
        this.saveNamespaceWithInjectedFault(Fault.WRITE_STORAGE_ONE);
    }

    @Test
    public void testFailedSaveNamespace() throws Exception {
        this.doTestFailedSaveNamespace(false);
    }

    @Test
    public void testFailedSaveNamespaceWithRecovery() throws Exception {
        this.doTestFailedSaveNamespace(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestFailedSaveNamespace(boolean restoreStorageAfterFailure) throws Exception {
        FSImage spyImage;
        NNStorage spyStorage;
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = new FSNamesystem(conf);
        FSImage originalImage = fsn.dir.fsImage;
        NNStorage storage = originalImage.getStorage();
        storage.close();
        originalImage.storage = spyStorage = (NNStorage)Mockito.spy((Object)storage);
        fsn.dir.fsImage = spyImage = (FSImage)Mockito.spy((Object)originalImage);
        spyImage.storage.setStorageDirectories(FSNamesystem.getNamespaceDirs((Configuration)conf), FSNamesystem.getNamespaceEditsDirs((Configuration)conf));
        ((FSImage)Mockito.doThrow((Throwable)new IOException("Injected fault: saveFSImage")).when((Object)spyImage)).saveFSImage((Storage.StorageDirectory)Matchers.anyObject(), Mockito.anyLong());
        try {
            this.doAnEdit(fsn, 1);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            try {
                fsn.saveNamespace();
                Assert.fail((String)"saveNamespace did not fail even when all directories failed!");
            }
            catch (IOException ioe) {
                LOG.info((Object)"Got expected exception", (Throwable)ioe);
            }
            if (restoreStorageAfterFailure) {
                Mockito.reset((Object[])new FSImage[]{spyImage});
                spyStorage.setRestoreFailedStorage(true);
                fsn.saveNamespace();
                this.checkEditExists(fsn, 1);
            }
            originalImage.close();
            fsn.close();
            fsn = null;
            fsn = new FSNamesystem(conf);
            this.checkEditExists(fsn, 1);
        }
        finally {
            if (fsn != null) {
                fsn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveWhileEditsRolled() throws Exception {
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = new FSNamesystem(conf);
        try {
            this.doAnEdit(fsn, 1);
            CheckpointSignature sig = fsn.rollEditLog();
            LOG.warn((Object)("Checkpoint signature: " + sig));
            this.doAnEdit(fsn, 2);
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fsn.saveNamespace();
            fsn.close();
            fsn = null;
            fsn = new FSNamesystem(conf);
            this.checkEditExists(fsn, 1);
            this.checkEditExists(fsn, 2);
        }
        finally {
            if (fsn != null) {
                fsn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxIdPersistence() throws Exception {
        Configuration conf = this.getConf();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode(conf);
        FSNamesystem fsn = new FSNamesystem(conf);
        try {
            Assert.assertEquals((long)1L, (long)fsn.getEditLog().getLastWrittenTxId());
            this.doAnEdit(fsn, 1);
            Assert.assertEquals((long)2L, (long)fsn.getEditLog().getLastWrittenTxId());
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fsn.saveNamespace();
            Assert.assertEquals((long)4L, (long)fsn.getEditLog().getLastWrittenTxId());
            fsn.getFSImage().close();
            fsn.close();
            Assert.assertEquals((long)5L, (long)fsn.getEditLog().getLastWrittenTxId());
            fsn = null;
            fsn = new FSNamesystem(conf);
            Assert.assertEquals((long)6L, (long)fsn.getEditLog().getLastWrittenTxId());
        }
        finally {
            if (fsn != null) {
                fsn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveNamespaceWithRenamedLease() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(new Configuration()).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = (DistributedFileSystem)cluster.getFileSystem();
        FSDataOutputStream out = null;
        try {
            fs.mkdirs(new Path("/test-target"));
            out = fs.create(new Path("/test-source/foo"));
            fs.rename(new Path("/test-source/"), new Path("/test-target/"));
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out, fs});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out, fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    private void doAnEdit(FSNamesystem fsn, int id) throws IOException {
        fsn.mkdirs("/test" + id, new PermissionStatus("test", "Test", new FsPermission(511)), true);
    }

    private void checkEditExists(FSNamesystem fsn, int id) throws IOException {
        Assert.assertNotNull((Object)fsn.getFileInfo("/test" + id, false));
    }

    private Configuration getConf() throws IOException {
        String baseDir = MiniDFSCluster.getBaseDirectory();
        String nameDirs = Util.fileAsURI((File)new File(baseDir, "name1")) + "," + Util.fileAsURI((File)new File(baseDir, "name2"));
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        conf.set("dfs.namenode.name.dir", nameDirs);
        conf.set("dfs.namenode.edits.dir", nameDirs);
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
        conf.setBoolean("dfs.permissions.enabled", false);
        return conf;
    }

    static {
        ((Log4JLogger)FSImage.LOG).getLogger().setLevel(Level.ALL);
        LOG = LogFactory.getLog(TestSaveNamespace.class);
    }

    private static enum Fault {
        SAVE_SECOND_FSIMAGE_RTE,
        SAVE_SECOND_FSIMAGE_IOE,
        SAVE_ALL_FSIMAGES,
        WRITE_STORAGE_ALL,
        WRITE_STORAGE_ONE;

    }

    private static class FaultySaveImage
    implements Answer<Void> {
        int count = 0;
        boolean throwRTE = true;

        public FaultySaveImage(boolean throwRTE) {
            this.throwRTE = throwRTE;
        }

        public Void answer(InvocationOnMock invocation) throws Throwable {
            Object[] args = invocation.getArguments();
            Storage.StorageDirectory sd = (Storage.StorageDirectory)args[0];
            if (this.count++ == 1) {
                LOG.info((Object)("Injecting fault for sd: " + sd));
                if (this.throwRTE) {
                    throw new RuntimeException("Injected fault: saveFSImage second time");
                }
                throw new IOException("Injected fault: saveFSImage second time");
            }
            LOG.info((Object)("Not injecting fault for sd: " + sd));
            return (Void)invocation.callRealMethod();
        }
    }
}

