/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;

public class TestParallelImageWrite
extends TestCase {
    private static final int NUM_DATANODES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRestartDFS() throws Exception {
        FileStatus dirstatus;
        FileStatus rootstatus;
        long rootmtime;
        int numNamenodeDirs;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        FSNamesystem fsn = null;
        DFSTestUtil files = new DFSTestUtil("TestRestartDFS", 200, 3, 8192);
        String dir = "/srcdat";
        Path rootpath = new Path("/");
        Path dirpath = new Path("/srcdat");
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(4).build();
            String[] nameNodeDirs = conf.getStrings("dfs.namenode.name.dir", new String[0]);
            numNamenodeDirs = nameNodeDirs.length;
            TestParallelImageWrite.assertTrue((String)"failed to get number of Namenode StorageDirs", (numNamenodeDirs != 0 ? 1 : 0) != 0);
            FileSystem fs = cluster.getFileSystem();
            files.createFiles(fs, "/srcdat");
            rootmtime = fs.getFileStatus(rootpath).getModificationTime();
            rootstatus = fs.getFileStatus(dirpath);
            dirstatus = fs.getFileStatus(dirpath);
            fs.setOwner(rootpath, rootstatus.getOwner() + "_XXX", null);
            fs.setOwner(dirpath, null, dirstatus.getGroup() + "_XXX");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            conf.setInt("dfs.namenode.checkpoint.txns", 1);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).format(false).numDataNodes(4).build();
            fsn = cluster.getNamesystem();
            FileSystem fs = cluster.getFileSystem();
            TestParallelImageWrite.assertTrue((String)"Filesystem corrupted after restart.", (boolean)files.checkFiles(fs, "/srcdat"));
            FileStatus newrootstatus = fs.getFileStatus(rootpath);
            TestParallelImageWrite.assertEquals((long)rootmtime, (long)newrootstatus.getModificationTime());
            TestParallelImageWrite.assertEquals((String)(rootstatus.getOwner() + "_XXX"), (String)newrootstatus.getOwner());
            TestParallelImageWrite.assertEquals((String)rootstatus.getGroup(), (String)newrootstatus.getGroup());
            FileStatus newdirstatus = fs.getFileStatus(dirpath);
            TestParallelImageWrite.assertEquals((String)dirstatus.getOwner(), (String)newdirstatus.getOwner());
            TestParallelImageWrite.assertEquals((String)(dirstatus.getGroup() + "_XXX"), (String)newdirstatus.getGroup());
            rootmtime = fs.getFileStatus(rootpath).getModificationTime();
            String checkAfterRestart = TestParallelImageWrite.checkImages(fsn, numNamenodeDirs);
            files.cleanup(fs, "/srcdat");
            files.createFiles(fs, "/srcdat");
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            String checkAfterModify = TestParallelImageWrite.checkImages(fsn, numNamenodeDirs);
            TestParallelImageWrite.assertFalse((String)("Modified namespace should change fsimage contents. was: " + checkAfterRestart + " now: " + checkAfterModify), (boolean)checkAfterRestart.equals(checkAfterModify));
            fsn.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            files.cleanup(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public static String checkImages(FSNamesystem fsn, int numImageDirs) throws Exception {
        NNStorage stg = fsn.getFSImage().getStorage();
        TestParallelImageWrite.assertEquals((String)"Some StorageDirectories failed Upgrade", (int)numImageDirs, (int)stg.getNumStorageDirs(NNStorage.NameNodeDirType.IMAGE));
        TestParallelImageWrite.assertTrue((String)"Not enough fsimage copies in MiniDFSCluster to test parallel write", (numImageDirs > 1 ? 1 : 0) != 0);
        List<File> dirs = FSImageTestUtil.getCurrentDirs(stg, NNStorage.NameNodeDirType.IMAGE);
        FSImageTestUtil.assertParallelFilesAreIdentical(dirs, Collections.<String>emptySet());
        FSImageTestUtil.assertSameNewestImage(dirs);
        Storage.StorageDirectory firstSd = (Storage.StorageDirectory)stg.dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE).next();
        File latestImage = FSImageTestUtil.findLatestImageFile(firstSd);
        String md5 = FSImageTestUtil.getImageFileMD5IgnoringTxId(latestImage);
        System.err.println("md5 of " + latestImage + ": " + md5);
        return md5;
    }
}

