/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourceChecker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNameNodeResourceChecker {
    private Configuration conf;
    private File baseDir;
    private File nameDir;

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.baseDir = new File(System.getProperty("test.build.data"));
        this.nameDir = new File(this.baseDir, "resource-check-name-dir");
        this.nameDir.mkdirs();
        this.conf.set("dfs.namenode.name.dir", this.nameDir.getAbsolutePath());
    }

    @Test
    public void testCheckAvailability() throws IOException {
        this.conf.setLong("dfs.namenode.resource.du.reserved", 0L);
        NameNodeResourceChecker nb = new NameNodeResourceChecker(this.conf);
        Assert.assertTrue((String)"isResourceAvailable must return true if disk usage is lower than threshold", (boolean)nb.hasAvailableDiskSpace());
    }

    @Test
    public void testCheckAvailabilityNeg() throws IOException {
        this.conf.setLong("dfs.namenode.resource.du.reserved", Long.MAX_VALUE);
        NameNodeResourceChecker nb = new NameNodeResourceChecker(this.conf);
        Assert.assertFalse((String)"isResourceAvailable must return false if disk usage is higher than threshold", (boolean)nb.hasAvailableDiskSpace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckThatNameNodeResourceMonitorIsRunning() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            this.conf.set("dfs.namenode.name.dir", this.nameDir.getAbsolutePath());
            this.conf.setLong("dfs.namenode.resource.check.interval", 1L);
            cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
            NameNodeResourceChecker mockResourceChecker = (NameNodeResourceChecker)Mockito.mock(NameNodeResourceChecker.class);
            Mockito.when((Object)mockResourceChecker.hasAvailableDiskSpace()).thenReturn((Object)true);
            cluster.getNameNode().getNamesystem().nnResourceChecker = mockResourceChecker;
            cluster.waitActive();
            String name = FSNamesystem.NameNodeResourceMonitor.class.getName();
            boolean isNameNodeMonitorRunning = false;
            Set<Thread> runningThreads = Thread.getAllStackTraces().keySet();
            for (Thread runningThread : runningThreads) {
                if (!runningThread.toString().startsWith("Thread[" + name)) continue;
                isNameNodeMonitorRunning = true;
                break;
            }
            Assert.assertTrue((String)"NN resource monitor should be running", (boolean)isNameNodeMonitorRunning);
            Assert.assertFalse((String)"NN should not presently be in safe mode", (boolean)cluster.getNameNode().isInSafeMode());
            Mockito.when((Object)mockResourceChecker.hasAvailableDiskSpace()).thenReturn((Object)false);
            long startMillis = System.currentTimeMillis();
            while (!cluster.getNameNode().isInSafeMode() && System.currentTimeMillis() < startMillis + 60000L) {
                Thread.sleep(1000L);
            }
            Assert.assertTrue((String)"NN should be in safe mode after resources crossed threshold", (boolean)cluster.getNameNode().isInSafeMode());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testChecking2NameDirsOnOneVolume() throws IOException {
        Configuration conf = new Configuration();
        File nameDir1 = new File(System.getProperty("test.build.data"), "name-dir1");
        File nameDir2 = new File(System.getProperty("test.build.data"), "name-dir2");
        nameDir1.mkdirs();
        nameDir2.mkdirs();
        conf.set("dfs.namenode.name.dir", nameDir1.getAbsolutePath() + "," + nameDir2.getAbsolutePath());
        conf.setLong("dfs.namenode.resource.du.reserved", Long.MAX_VALUE);
        NameNodeResourceChecker nb = new NameNodeResourceChecker(conf);
        Assert.assertEquals((String)"Should not check the same volume more than once.", (long)1L, (long)nb.getVolumesLowOnSpace().size());
    }

    @Test
    public void testCheckingExtraVolumes() throws IOException {
        Configuration conf = new Configuration();
        File nameDir = new File(System.getProperty("test.build.data"), "name-dir");
        nameDir.mkdirs();
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        conf.set("dfs.namenode.resource.checked.volumes", nameDir.getAbsolutePath());
        conf.setLong("dfs.namenode.resource.du.reserved", Long.MAX_VALUE);
        NameNodeResourceChecker nb = new NameNodeResourceChecker(conf);
        Assert.assertEquals((String)"Should not check the same volume more than once.", (long)1L, (long)nb.getVolumesLowOnSpace().size());
    }

    @Test
    public void testLowResourceVolumePolicy() throws IOException {
        Configuration conf = new Configuration();
        File nameDir1 = new File(System.getProperty("test.build.data"), "name-dir1");
        File nameDir2 = new File(System.getProperty("test.build.data"), "name-dir2");
        nameDir1.mkdirs();
        nameDir2.mkdirs();
        conf.set("dfs.namenode.name.dir", nameDir1.getAbsolutePath() + "," + nameDir2.getAbsolutePath());
        NameNodeResourceChecker nnrc = new NameNodeResourceChecker(conf);
        HashMap<String, DF> volumes = new HashMap<String, DF>();
        volumes.put("volume1", new DF(nameDir1, conf));
        volumes.put("volume2", new DF(nameDir2, conf));
        nnrc.setVolumes(volumes);
        NameNodeResourceChecker spyNnrc = (NameNodeResourceChecker)Mockito.spy((Object)nnrc);
        Mockito.when((Object)spyNnrc.getVolumesLowOnSpace()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"volume1"}));
        Assert.assertTrue((boolean)spyNnrc.hasAvailableDiskSpace());
        Mockito.when((Object)spyNnrc.getVolumesLowOnSpace()).thenReturn((Object)Lists.newArrayList((Object[])new String[]{"volume1", "volume2"}));
        Assert.assertFalse((boolean)spyNnrc.hasAvailableDiskSpace());
    }
}

