/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestNameNodeMXBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameNodeMXBeanInfo() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            String clusterId = (String)mbs.getAttribute(mxbeanName, "ClusterId");
            junit.framework.Assert.assertEquals((String)fsn.getClusterId(), (String)clusterId);
            String blockpoolId = (String)mbs.getAttribute(mxbeanName, "BlockPoolId");
            junit.framework.Assert.assertEquals((String)fsn.getBlockPoolId(), (String)blockpoolId);
            String version = (String)mbs.getAttribute(mxbeanName, "Version");
            junit.framework.Assert.assertEquals((String)fsn.getVersion(), (String)version);
            junit.framework.Assert.assertTrue((boolean)version.equals(VersionInfo.getVersion() + ", r" + VersionInfo.getRevision()));
            Long used = (Long)mbs.getAttribute(mxbeanName, "Used");
            junit.framework.Assert.assertEquals((long)fsn.getUsed(), (long)used);
            Long total = (Long)mbs.getAttribute(mxbeanName, "Total");
            junit.framework.Assert.assertEquals((long)fsn.getTotal(), (long)total);
            String safemode = (String)mbs.getAttribute(mxbeanName, "Safemode");
            junit.framework.Assert.assertEquals((String)fsn.getSafemode(), (String)safemode);
            Long nondfs = (Long)mbs.getAttribute(mxbeanName, "NonDfsUsedSpace");
            junit.framework.Assert.assertEquals((long)fsn.getNonDfsUsedSpace(), (long)nondfs);
            Float percentremaining = (Float)mbs.getAttribute(mxbeanName, "PercentRemaining");
            junit.framework.Assert.assertEquals((Object)Float.valueOf(fsn.getPercentRemaining()), (Object)Float.valueOf(percentremaining.floatValue()));
            Long totalblocks = (Long)mbs.getAttribute(mxbeanName, "TotalBlocks");
            junit.framework.Assert.assertEquals((long)fsn.getTotalBlocks(), (long)totalblocks);
            String alivenodeinfo = (String)mbs.getAttribute(mxbeanName, "LiveNodes");
            junit.framework.Assert.assertEquals((String)fsn.getLiveNodes(), (String)alivenodeinfo);
            String deadnodeinfo = (String)mbs.getAttribute(mxbeanName, "DeadNodes");
            junit.framework.Assert.assertEquals((String)fsn.getDeadNodes(), (String)deadnodeinfo);
            String nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            junit.framework.Assert.assertEquals((String)fsn.getNameDirStatuses(), (String)nameDirStatuses);
            Map statusMap = (Map)JSON.parse((String)nameDirStatuses);
            Collection<URI> nameDirUris = cluster.getNameDirs(0);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                System.out.println("Checking for the presence of " + nameDir + " in active name dirs.");
                Assert.assertTrue((boolean)((Map)statusMap.get("active")).containsKey(nameDir.getAbsolutePath()));
            }
            Assert.assertEquals((long)2L, (long)((Map)statusMap.get("active")).size());
            Assert.assertEquals((long)0L, (long)((Map)statusMap.get("failed")).size());
            File failedNameDir = new File(nameDirUris.toArray(new URI[0])[0]);
            Assert.assertEquals((long)0L, (long)FileUtil.chmod((String)failedNameDir.getAbsolutePath(), (String)"000"));
            cluster.getNameNodeRpc().rollEditLog();
            nameDirStatuses = (String)mbs.getAttribute(mxbeanName, "NameDirStatuses");
            statusMap = (Map)JSON.parse((String)nameDirStatuses);
            for (URI nameDirUri : nameDirUris) {
                File nameDir = new File(nameDirUri);
                String expectedStatus = nameDir.equals(failedNameDir) ? "failed" : "active";
                System.out.println("Checking for the presence of " + nameDir + " in " + expectedStatus + " name dirs.");
                Assert.assertTrue((boolean)((Map)statusMap.get(expectedStatus)).containsKey(nameDir.getAbsolutePath()));
            }
            Assert.assertEquals((long)1L, (long)((Map)statusMap.get("active")).size());
            Assert.assertEquals((long)1L, (long)((Map)statusMap.get("failed")).size());
        }
        finally {
            if (cluster != null) {
                for (URI dir : cluster.getNameDirs(0)) {
                    FileUtil.chmod((String)new File(dir).toString(), (String)"700");
                }
                cluster.shutdown();
            }
        }
    }
}

