/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NamenodeJspHelper;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNameNodeJspHelper {
    private MiniDFSCluster cluster = null;
    Configuration conf = null;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testDelegationToken() throws IOException, InterruptedException {
        NamenodeProtocols nn = this.cluster.getNameNodeRpc();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"auser");
        String tokenString = NamenodeJspHelper.getDelegationToken((NamenodeProtocols)nn, (HttpServletRequest)request, (Configuration)this.conf, (UserGroupInformation)ugi);
        Assert.assertEquals(null, (Object)tokenString);
    }

    @Test
    public void tesSecurityModeText() {
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        String securityOnOff = NamenodeJspHelper.getSecurityModeText();
        Assert.assertTrue((String)"security mode doesn't match. Should be ON", (boolean)securityOnOff.contains("ON"));
        this.conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        securityOnOff = NamenodeJspHelper.getSecurityModeText();
        Assert.assertTrue((String)"security mode doesn't match. Should be OFF", (boolean)securityOnOff.contains("OFF"));
    }
}

