/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;

public class TestLargeDirectoryDelete {
    private static final Log LOG = LogFactory.getLog(TestLargeDirectoryDelete.class);
    private static final Configuration CONF = new HdfsConfiguration();
    private static final int TOTAL_BLOCKS = 10000;
    private MiniDFSCluster mc = null;
    private int createOps = 0;
    private int lockOps = 0;

    private void createFile(String fileName, long filelen) throws IOException {
        FileSystem fs = this.mc.getFileSystem();
        Path filePath = new Path(fileName);
        DFSTestUtil.createFile(fs, filePath, filelen, (short)1, 0L);
    }

    private void createFiles() throws IOException {
        Random rand = new Random();
        for (int i = 0; i < 10000; i += 100) {
            String filename = "/root/";
            int dirs = rand.nextInt(10);
            for (int j = i; j >= i - dirs; --j) {
                filename = filename + j + "/";
            }
            filename = filename + "file" + i;
            this.createFile(filename, 100L);
        }
    }

    private int getBlockCount() {
        Assert.assertNotNull((String)"Null cluster", (Object)this.mc);
        Assert.assertNotNull((String)"No Namenode in cluster", (Object)this.mc.getNameNode());
        FSNamesystem namesystem = this.mc.getNamesystem();
        Assert.assertNotNull((String)"Null Namesystem in cluster", (Object)namesystem);
        Assert.assertNotNull((String)"Null Namesystem.blockmanager", (Object)namesystem.getBlockManager());
        return (int)namesystem.getBlocksTotal();
    }

    private void runThreads() throws Throwable {
        TestThread[] threads = new TestThread[]{new TestThread(){

            @Override
            protected void execute() throws Throwable {
                while (this.live) {
                    try {
                        int blockcount = TestLargeDirectoryDelete.this.getBlockCount();
                        if (blockcount >= 10000 || blockcount <= 0) continue;
                        String file = "/tmp" + TestLargeDirectoryDelete.this.createOps;
                        TestLargeDirectoryDelete.this.createFile(file, 1L);
                        TestLargeDirectoryDelete.this.mc.getFileSystem().delete(new Path(file), true);
                        TestLargeDirectoryDelete.this.createOps++;
                    }
                    catch (IOException ex) {
                        LOG.info((Object)"createFile exception ", (Throwable)ex);
                        break;
                    }
                }
            }
        }, new TestThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void execute() throws Throwable {
                while (this.live) {
                    try {
                        int blockcount = TestLargeDirectoryDelete.this.getBlockCount();
                        if (blockcount >= 10000 || blockcount <= 0) continue;
                        TestLargeDirectoryDelete.this.mc.getNamesystem().writeLock();
                        try {
                            TestLargeDirectoryDelete.this.lockOps++;
                        }
                        finally {
                            TestLargeDirectoryDelete.this.mc.getNamesystem().writeUnlock();
                        }
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        LOG.info((Object)"lockOperation exception ", (Throwable)ex);
                        break;
                    }
                }
            }
        }};
        threads[0].start();
        threads[1].start();
        long start = System.currentTimeMillis();
        FSNamesystem.BLOCK_DELETION_INCREMENT = 1;
        this.mc.getFileSystem().delete(new Path("/root"), true);
        long end = System.currentTimeMillis();
        threads[0].endThread();
        threads[1].endThread();
        LOG.info((Object)("Deletion took " + (end - start) + "msecs"));
        LOG.info((Object)("createOperations " + this.createOps));
        LOG.info((Object)("lockOperations " + this.lockOps));
        Assert.assertTrue((this.lockOps + this.createOps > 0 ? 1 : 0) != 0);
        threads[0].rethrow();
        threads[1].rethrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void largeDelete() throws Throwable {
        this.mc = new MiniDFSCluster.Builder(CONF).build();
        try {
            this.mc.waitActive();
            Assert.assertNotNull((String)"No Namenode in cluster", (Object)this.mc.getNameNode());
            this.createFiles();
            Assert.assertEquals((long)10000L, (long)this.getBlockCount());
            this.runThreads();
        }
        finally {
            this.mc.shutdown();
        }
    }

    static {
        CONF.setLong("dfs.blocksize", 1L);
        CONF.setInt("dfs.bytes-per-checksum", 1);
    }

    private abstract class TestThread
    extends Thread {
        volatile Throwable thrown;
        protected volatile boolean live = true;

        private TestThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (Throwable throwable) {
                LOG.warn((Object)throwable);
                this.setThrown(throwable);
            }
            finally {
                TestThread testThread = this;
                synchronized (testThread) {
                    this.notify();
                }
            }
        }

        protected abstract void execute() throws Throwable;

        protected synchronized void setThrown(Throwable thrown) {
            this.thrown = thrown;
        }

        public synchronized void rethrow() throws Throwable {
            if (this.thrown != null) {
                throw this.thrown;
            }
        }

        public synchronized void endThread() {
            block2: {
                this.live = false;
                this.interrupt();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug((Object)("Ignoring " + e), (Throwable)e);
                }
            }
        }
    }
}

