/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;

public class TestFileLimit
extends TestCase {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    boolean simulatedStorage = false;

    private void createFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)1, 8192L);
        byte[] buffer = new byte[1024];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void waitForLimit(FSNamesystem namesys, long num) {
        while (true) {
            long total = namesys.getBlocksTotal() + namesys.dir.totalInodes();
            System.out.println("Comparing current nodes " + total + " to become " + num);
            if (total == num) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileLimit() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int maxObjects = 5;
        conf.setLong("dfs.namenode.max.objects", (long)maxObjects);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.setInt("dfs.heartbeat.interval", 1);
        int currentNodes = 0;
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = cluster.getFileSystem();
        FSNamesystem namesys = cluster.getNamesystem();
        try {
            Path file;
            Path path = new Path("/");
            TestFileLimit.assertTrue((String)"/ should be a directory", (boolean)fs.getFileStatus(path).isDirectory());
            currentNodes = 1;
            for (int i = 0; i < maxObjects / 2; ++i) {
                file = new Path("/filestatus" + i);
                this.createFile(fs, file);
                System.out.println("Created file " + file);
                currentNodes += 2;
            }
            boolean hitException = false;
            try {
                file = new Path("/filestatus");
                this.createFile(fs, file);
                System.out.println("Created file " + file);
            }
            catch (IOException e) {
                hitException = true;
            }
            TestFileLimit.assertTrue((String)"Was able to exceed file limit", (boolean)hitException);
            Path file0 = new Path("/filestatus0");
            fs.delete(file0, true);
            System.out.println("Deleted file " + file0);
            this.waitForLimit(namesys, currentNodes -= 2);
            this.createFile(fs, file0);
            System.out.println("Created file " + file0 + " again.");
            currentNodes += 2;
            file0 = new Path("/filestatus0");
            fs.delete(file0, true);
            System.out.println("Deleted file " + file0 + " again.");
            this.waitForLimit(namesys, currentNodes -= 2);
            Path dir = new Path("/dir0/dir1");
            fs.mkdirs(dir);
            System.out.println("Created directories " + dir);
            this.waitForLimit(namesys, currentNodes += 2);
            hitException = false;
            try {
                fs.mkdirs(new Path("dir.fail"));
                System.out.println("Created directory should not have succeeded.");
            }
            catch (IOException e) {
                hitException = true;
            }
            TestFileLimit.assertTrue((String)"Was able to exceed dir limit", (boolean)hitException);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    public void testFileLimitSimulated() throws IOException {
        this.simulatedStorage = true;
        this.testFileLimit();
        this.simulatedStorage = false;
    }
}

