/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFileJournalManager {
    @Test
    public void testGetRemoteEditLog() throws IOException {
        Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, false, NNStorage.getFinalizedEditsFileName((long)1L, (long)100L), NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), NNStorage.getInProgressEditsFileName((long)201L), NNStorage.getFinalizedEditsFileName((long)1001L, (long)1100L));
        FileJournalManager fjm = new FileJournalManager(sd);
        Assert.assertEquals((Object)"[1,100],[101,200],[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 1L));
        Assert.assertEquals((Object)"[101,200],[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 101L));
        Assert.assertEquals((Object)"[1001,1100]", (Object)TestFileJournalManager.getLogsAsString(fjm, 201L));
        try {
            Assert.assertEquals((Object)"[]", (Object)TestFileJournalManager.getLogsAsString(fjm, 150L));
            Assert.fail((String)"Did not throw when asking for a txn in the middle of a log");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"150 which is in the middle", (Throwable)ioe);
        }
        Assert.assertEquals((String)"Asking for a newer log than exists should return empty list", (Object)"", (Object)TestFileJournalManager.getLogsAsString(fjm, 9999L));
    }

    private static String getLogsAsString(FileJournalManager fjm, long firstTxId) throws IOException {
        return Joiner.on((String)",").join((Iterable)fjm.getRemoteEditLogs(firstTxId));
    }
}

