/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSImageStorageInspector {
    private static final Log LOG = LogFactory.getLog(TestFSImageStorageInspector.class);

    @Test
    public void testCurrentStorageInspector() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        Storage.StorageDirectory mockDir = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE_AND_EDITS, false, "/foo/current/" + NNStorage.getImageFileName((long)123L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L), "/foo/current/" + NNStorage.getImageFileName((long)456L), "/foo/current/" + NNStorage.getInProgressEditsFileName((long)457L));
        inspector.inspectDirectory(mockDir);
        this.mockLogValidation(inspector, "/foo/current/" + NNStorage.getInProgressEditsFileName((long)457L), 10);
        Assert.assertEquals((long)2L, (long)inspector.foundEditLogs.size());
        Assert.assertEquals((long)2L, (long)inspector.foundImages.size());
        Assert.assertTrue((boolean)((FileJournalManager.EditLogFile)inspector.foundEditLogs.get(1)).isInProgress());
        FSImageStorageInspector.FSImageFile latestImage = inspector.getLatestImage();
        Assert.assertEquals((long)456L, (long)latestImage.txId);
        Assert.assertSame((Object)mockDir, (Object)latestImage.sd);
        Assert.assertTrue((boolean)inspector.isUpgradeFinalized());
        FSImageStorageInspector.LoadPlan plan = inspector.createLoadPlan();
        LOG.info((Object)("Plan: " + plan));
        Assert.assertEquals((Object)new File("/foo/current/" + NNStorage.getImageFileName((long)456L)), (Object)plan.getImageFile());
        Assert.assertArrayEquals((Object[])new File[]{new File("/foo/current/" + NNStorage.getInProgressEditsFileName((long)457L))}, (Object[])plan.getEditsFiles().toArray(new File[0]));
    }

    @Test
    public void testPlanWithGaps() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        Storage.StorageDirectory mockDir = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE_AND_EDITS, false, "/foo/current/" + NNStorage.getImageFileName((long)123L), "/foo/current/" + NNStorage.getImageFileName((long)456L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)457L, (long)900L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)901L, (long)950L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)952L, (long)1000L));
        inspector.inspectDirectory(mockDir);
        try {
            inspector.createLoadPlan();
            Assert.fail((String)"Didn't throw IOE trying to load with gaps in edits");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("would start at txid 951 but starts at txid 952"));
        }
    }

    @Test
    public void testPlanWithInProgressInMiddle() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        Storage.StorageDirectory mockDir = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE_AND_EDITS, false, "/foo/current/" + NNStorage.getImageFileName((long)123L), "/foo/current/" + NNStorage.getImageFileName((long)456L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)457L, (long)900L), "/foo/current/" + NNStorage.getInProgressEditsFileName((long)901L), "/foo/current/" + NNStorage.getFinalizedEditsFileName((long)952L, (long)1000L));
        inspector.inspectDirectory(mockDir);
        this.mockLogValidation(inspector, "/foo/current/" + NNStorage.getInProgressEditsFileName((long)901L), 51);
        FSImageStorageInspector.LoadPlan plan = inspector.createLoadPlan();
        LOG.info((Object)("Plan: " + plan));
        Assert.assertEquals((Object)new File("/foo/current/" + NNStorage.getImageFileName((long)456L)), (Object)plan.getImageFile());
        Assert.assertArrayEquals((Object[])new File[]{new File("/foo/current/" + NNStorage.getFinalizedEditsFileName((long)457L, (long)900L)), new File("/foo/current/" + NNStorage.getInProgressEditsFileName((long)901L)), new File("/foo/current/" + NNStorage.getFinalizedEditsFileName((long)952L, (long)1000L))}, (Object[])plan.getEditsFiles().toArray(new File[0]));
    }

    @Test
    public void testLogGroupRecoveryNoop() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L)));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L)));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo3/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L)));
        FSImageTransactionalStorageInspector.LogGroup lg = (FSImageTransactionalStorageInspector.LogGroup)inspector.logGroups.get(123L);
        Assert.assertEquals((long)3L, (long)lg.logs.size());
        lg.planRecovery();
        Assert.assertFalse((boolean)((FileJournalManager.EditLogFile)lg.logs.get(0)).isCorrupt());
        Assert.assertFalse((boolean)((FileJournalManager.EditLogFile)lg.logs.get(1)).isCorrupt());
        Assert.assertFalse((boolean)((FileJournalManager.EditLogFile)lg.logs.get(2)).isCorrupt());
    }

    @Test
    public void testLogGroupRecoveryMixed() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L)));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L)));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo3/current/" + NNStorage.getInProgressEditsFileName((long)123L)));
        inspector.inspectDirectory(FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE, false, "/foo4/current/" + NNStorage.getImageFileName((long)122L)));
        FSImageTransactionalStorageInspector.LogGroup lg = (FSImageTransactionalStorageInspector.LogGroup)inspector.logGroups.get(123L);
        Assert.assertEquals((long)3L, (long)lg.logs.size());
        FileJournalManager.EditLogFile inProgressLog = (FileJournalManager.EditLogFile)lg.logs.get(2);
        Assert.assertTrue((boolean)inProgressLog.isInProgress());
        FSImageStorageInspector.LoadPlan plan = inspector.createLoadPlan();
        Assert.assertFalse((boolean)((FileJournalManager.EditLogFile)lg.logs.get(0)).isCorrupt());
        Assert.assertFalse((boolean)((FileJournalManager.EditLogFile)lg.logs.get(1)).isCorrupt());
        Assert.assertTrue((boolean)((FileJournalManager.EditLogFile)lg.logs.get(2)).isCorrupt());
        inProgressLog = (FileJournalManager.EditLogFile)Mockito.spy((Object)inProgressLog);
        ((FileJournalManager.EditLogFile)Mockito.doNothing().when((Object)inProgressLog)).moveAsideCorruptFile();
        lg.logs.set(2, inProgressLog);
        plan.doRecovery();
        ((FileJournalManager.EditLogFile)Mockito.verify((Object)inProgressLog)).moveAsideCorruptFile();
    }

    @Test
    public void testLogGroupRecoveryInconsistentEndTxIds() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L)));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)678L)));
        FSImageTransactionalStorageInspector.LogGroup lg = (FSImageTransactionalStorageInspector.LogGroup)inspector.logGroups.get(123L);
        Assert.assertEquals((long)2L, (long)lg.logs.size());
        try {
            lg.planRecovery();
            Assert.fail((String)"Didn't throw IOE on inconsistent end txids");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)ioe.getMessage().contains("More than one ending txid"));
        }
    }

    @Test
    public void testLogGroupRecoveryInProgress() throws IOException {
        String[] paths = new String[]{"/foo1/current/" + NNStorage.getInProgressEditsFileName((long)123L), "/foo2/current/" + NNStorage.getInProgressEditsFileName((long)123L), "/foo3/current/" + NNStorage.getInProgressEditsFileName((long)123L)};
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs(paths[0]));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs(paths[1]));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs(paths[2]));
        this.mockLogValidation(inspector, paths[0], 2000);
        this.mockLogValidation(inspector, paths[1], 2000);
        this.mockLogValidation(inspector, paths[2], 1000);
        FSImageTransactionalStorageInspector.LogGroup lg = (FSImageTransactionalStorageInspector.LogGroup)inspector.logGroups.get(123L);
        Assert.assertEquals((long)3L, (long)lg.logs.size());
        lg.planRecovery();
        Assert.assertFalse((boolean)((FileJournalManager.EditLogFile)lg.logs.get(0)).isCorrupt());
        Assert.assertFalse((boolean)((FileJournalManager.EditLogFile)lg.logs.get(1)).isCorrupt());
        Assert.assertTrue((boolean)((FileJournalManager.EditLogFile)lg.logs.get(2)).isCorrupt());
        FileJournalManager.EditLogFile badLog = (FileJournalManager.EditLogFile)lg.logs.get(2);
        ((FileJournalManager.EditLogFile)Mockito.doNothing().when((Object)badLog)).moveAsideCorruptFile();
        ((FileJournalManager.EditLogFile)Mockito.doNothing().when(lg.logs.get(0))).finalizeLog();
        ((FileJournalManager.EditLogFile)Mockito.doNothing().when(lg.logs.get(1))).finalizeLog();
        lg.recover();
        ((FileJournalManager.EditLogFile)Mockito.verify((Object)badLog)).moveAsideCorruptFile();
        ((FileJournalManager.EditLogFile)Mockito.verify(lg.logs.get(0))).finalizeLog();
        ((FileJournalManager.EditLogFile)Mockito.verify(lg.logs.get(1))).finalizeLog();
    }

    private void mockLogValidation(FSImageTransactionalStorageInspector inspector, String path, int numValidTransactions) throws IOException {
        for (FSImageTransactionalStorageInspector.LogGroup lg : inspector.logGroups.values()) {
            List logs = lg.logs;
            for (int i = 0; i < logs.size(); ++i) {
                FileJournalManager.EditLogFile log = (FileJournalManager.EditLogFile)logs.get(i);
                if (!log.getFile().getPath().equals(path)) continue;
                FileJournalManager.EditLogFile spyLog = (FileJournalManager.EditLogFile)Mockito.spy((Object)log);
                ((FileJournalManager.EditLogFile)Mockito.doReturn((Object)new FSEditLogLoader.EditLogValidation(-1L, (long)numValidTransactions)).when((Object)spyLog)).validateLog();
                logs.set(i, spyLog);
                return;
            }
        }
        Assert.fail((String)("No log found to mock out at " + path));
    }

    @Test
    public void testCurrentSplitEditsAndImage() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        Storage.StorageDirectory mockImageDir = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE, false, "/foo/current/" + NNStorage.getImageFileName((long)123L));
        Storage.StorageDirectory mockImageDir2 = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.IMAGE, false, "/foo2/current/" + NNStorage.getImageFileName((long)456L));
        Storage.StorageDirectory mockEditsDir = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, false, "/foo3/current/" + NNStorage.getFinalizedEditsFileName((long)123L, (long)456L), "/foo3/current/" + NNStorage.getInProgressEditsFileName((long)457L));
        inspector.inspectDirectory(mockImageDir);
        inspector.inspectDirectory(mockEditsDir);
        inspector.inspectDirectory(mockImageDir2);
        this.mockLogValidation(inspector, "/foo3/current/" + NNStorage.getInProgressEditsFileName((long)457L), 2);
        Assert.assertEquals((long)2L, (long)inspector.foundEditLogs.size());
        Assert.assertEquals((long)2L, (long)inspector.foundImages.size());
        Assert.assertTrue((boolean)((FileJournalManager.EditLogFile)inspector.foundEditLogs.get(1)).isInProgress());
        Assert.assertTrue((boolean)inspector.isUpgradeFinalized());
        FSImageTransactionalStorageInspector.TransactionalLoadPlan plan = (FSImageTransactionalStorageInspector.TransactionalLoadPlan)inspector.createLoadPlan();
        FSImageStorageInspector.FSImageFile pickedImage = plan.image;
        Assert.assertEquals((long)456L, (long)pickedImage.txId);
        Assert.assertSame((Object)mockImageDir2, (Object)pickedImage.sd);
        Assert.assertEquals((Object)new File("/foo2/current/" + NNStorage.getImageFileName((long)456L)), (Object)plan.getImageFile());
        Assert.assertArrayEquals((Object[])new File[]{new File("/foo3/current/" + NNStorage.getInProgressEditsFileName((long)457L))}, (Object[])plan.getEditsFiles().toArray(new File[0]));
    }

    @Test
    public void testLogManifestInProgressComesFirst() throws IOException {
        FSImageTransactionalStorageInspector inspector = new FSImageTransactionalStorageInspector();
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)2622L, (long)2623L), "/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)2624L, (long)2625L), "/foo1/current/" + NNStorage.getInProgressEditsFileName((long)2626L)));
        inspector.inspectDirectory(TestFSImageStorageInspector.mockDirectoryWithEditLogs("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)2622L, (long)2623L), "/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)2624L, (long)2625L), "/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)2626L, (long)2627L), "/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)2628L, (long)2629L)));
    }

    static Storage.StorageDirectory mockDirectoryWithEditLogs(String ... fileNames) {
        return FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, false, fileNames);
    }
}

