/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestEditLogJournalFailures {
    private int editsPerformed = 0;
    private MiniDFSCluster cluster;
    private FileSystem fs;

    @Before
    public void setUpMiniCluster() throws IOException {
        this.setUpMiniCluster((Configuration)new HdfsConfiguration(), true);
    }

    private void setUpMiniCluster(Configuration conf, boolean manageNameDfsDirs) throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).manageNameDfsDirs(manageNameDfsDirs).checkExitOnShutdown(false).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void shutDownMiniCluster() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            try {
                this.cluster.shutdown();
            }
            catch (ExitUtil.ExitException exitException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSingleFailedEditsDirOnFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true);
        Assert.assertTrue((boolean)this.doAnEdit());
        Assert.assertFalse((boolean)this.cluster.getNameNode().isInSafeMode());
    }

    @Test
    public void testAllEditsDirsFailOnFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, true);
        this.invalidateEditsDirAtIndex(1, true);
        try {
            this.doAnEdit();
            Assert.fail((String)"The previous edit could not be synced to any persistent storage, should have halted the NN");
        }
        catch (RemoteException re) {
            Assert.assertTrue((boolean)re.toString().contains("ExitException"));
            GenericTestUtils.assertExceptionContains((String)"Could not sync enough journals to persistent storage. Unsynced transactions: 1", (Throwable)re);
        }
    }

    @Test
    public void testSingleFailedEditsDirOnSetReadyToFlush() throws IOException {
        Assert.assertTrue((boolean)this.doAnEdit());
        this.invalidateEditsDirAtIndex(0, false);
        Assert.assertTrue((boolean)this.doAnEdit());
        Assert.assertFalse((boolean)this.cluster.getNameNode().isInSafeMode());
    }

    private EditLogOutputStream invalidateEditsDirAtIndex(int index, boolean failOnFlush) throws IOException {
        FSImage fsimage = this.cluster.getNamesystem().getFSImage();
        FSEditLog editLog = fsimage.getEditLog();
        FSEditLog.JournalAndStream jas = (FSEditLog.JournalAndStream)editLog.getJournals().get(index);
        EditLogFileOutputStream elos = (EditLogFileOutputStream)jas.getCurrentStream();
        EditLogFileOutputStream spyElos = (EditLogFileOutputStream)Mockito.spy((Object)elos);
        if (failOnFlush) {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on flush()")).when((Object)spyElos)).flush();
        } else {
            ((EditLogFileOutputStream)Mockito.doThrow((Throwable)new IOException("fail on setReadyToFlush()")).when((Object)spyElos)).setReadyToFlush();
        }
        ((EditLogFileOutputStream)Mockito.doNothing().when((Object)spyElos)).abort();
        jas.setCurrentStreamForTests((EditLogOutputStream)spyElos);
        return elos;
    }

    private boolean doAnEdit() throws IOException {
        return this.fs.mkdirs(new Path("/tmp", Integer.toString(this.editsPerformed++)));
    }
}

