/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestEditLogFileOutputStream {
    private static final int HEADER_LEN = 17;
    private static final File TEST_EDITS = new File(System.getProperty("test.build.data", "/tmp"), "editLogStream.dat");

    @Before
    public void deleteEditsFile() {
        TEST_EDITS.delete();
    }

    @Test
    public void testPreallocation() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        Storage.StorageDirectory sd = cluster.getNameNode().getFSImage().getStorage().getStorageDir(0);
        File editLog = NNStorage.getInProgressEditsFile((Storage.StorageDirectory)sd, (long)1L);
        FSEditLogLoader.EditLogValidation validation = EditLogFileInputStream.validateEditLog((File)editLog);
        Assert.assertEquals((String)"Edit log should contain a header as valid length", (long)17L, (long)validation.validLength);
        Assert.assertEquals((long)1L, (long)validation.numTransactions);
        Assert.assertEquals((String)"Edit log should have 1MB of bytes allocated", (long)0x100000L, (long)editLog.length());
        cluster.getFileSystem().mkdirs(new Path("/tmp"), new FsPermission(777));
        long oldLength = validation.validLength;
        validation = EditLogFileInputStream.validateEditLog((File)editLog);
        Assert.assertTrue((String)("Edit log should have more valid data after writing a txn (was: " + oldLength + " now: " + validation.validLength + ")"), (validation.validLength > oldLength ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)validation.numTransactions);
        Assert.assertEquals((String)"Edit log should be 1MB long", (long)0x100000L, (long)editLog.length());
        Assert.assertTrue((String)"Edit log disk space used should be at least 257 blocks", (0x100000L <= new DU(editLog, (Configuration)conf).getUsed() ? 1 : 0) != 0);
    }

    @Test
    public void testClose() throws IOException {
        String errorMessage = "TESTING: fc.truncate() threw IOE";
        File testDir = new File(System.getProperty("test.build.data", "/tmp"));
        Assert.assertTrue((String)"could not create test directory", (testDir.exists() || testDir.mkdirs() ? 1 : 0) != 0);
        File f = new File(testDir, "edits");
        Assert.assertTrue((String)"could not create test file", (boolean)f.createNewFile());
        EditLogFileOutputStream elos = new EditLogFileOutputStream(f, 0);
        FileChannel mockFc = (FileChannel)Mockito.spy((Object)elos.getFileChannelForTesting());
        ((FileChannel)Mockito.doThrow((Throwable)new IOException(errorMessage)).when((Object)mockFc)).truncate(Mockito.anyLong());
        elos.setFileChannelForTesting(mockFc);
        try {
            elos.close();
            Assert.fail((String)"elos.close() succeeded, but should have thrown");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"wrong IOE thrown from elos.close()", (Object)e.getMessage(), (Object)errorMessage);
        }
        Assert.assertEquals((String)"fc was not nulled when elos.close() failed", (Object)elos.getFileChannelForTesting(), null);
    }

    @Test
    public void testEditLogFileOutputStreamCloseAbort() throws IOException {
        EditLogFileOutputStream editLogStream = new EditLogFileOutputStream(TEST_EDITS, 0);
        editLogStream.close();
        editLogStream.abort();
    }

    @Test
    public void testEditLogFileOutputStreamCloseClose() throws IOException {
        EditLogFileOutputStream editLogStream = new EditLogFileOutputStream(TEST_EDITS, 0);
        editLogStream.close();
        try {
            editLogStream.close();
        }
        catch (IOException ioe) {
            String msg = StringUtils.stringifyException((Throwable)ioe);
            Assert.assertTrue((String)msg, (boolean)msg.contains("Trying to use aborted output stream"));
        }
    }

    @Test
    public void testEditLogFileOutputStreamAbortAbort() throws IOException {
        EditLogFileOutputStream editLogStream = new EditLogFileOutputStream(TEST_EDITS, 0);
        editLogStream.abort();
        editLogStream.abort();
    }
}

