/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.ipc.Server;

public class NameNodeAdapter {
    public static FSNamesystem getNamesystem(NameNode namenode) {
        return namenode.getNamesystem();
    }

    public static LocatedBlocks getBlockLocations(NameNode namenode, String src, long offset, long length) throws IOException {
        return namenode.getNamesystem().getBlockLocations(src, offset, length, false, true);
    }

    public static Server getRpcServer(NameNode namenode) {
        return ((NameNodeRpcServer)namenode.getRpcServer()).server;
    }

    public static DelegationTokenSecretManager getDtSecretManager(FSNamesystem ns) {
        return ns.getDelegationTokenSecretManager();
    }

    public static DatanodeCommand[] sendHeartBeat(DatanodeRegistration nodeReg, DatanodeDescriptor dd, FSNamesystem namesystem) throws IOException {
        return namesystem.handleHeartbeat(nodeReg, dd.getCapacity(), dd.getDfsUsed(), dd.getRemaining(), dd.getBlockPoolUsed(), 0, 0, 0);
    }

    public static boolean setReplication(FSNamesystem ns, String src, short replication) throws IOException {
        return ns.setReplication(src, replication);
    }

    public static LeaseManager getLeaseManager(FSNamesystem ns) {
        return ns.leaseManager;
    }

    public static void setLeasePeriod(FSNamesystem namesystem, long soft, long hard) {
        NameNodeAdapter.getLeaseManager(namesystem).setLeasePeriod(soft, hard);
        namesystem.lmthread.interrupt();
    }

    public static String getLeaseHolderForPath(NameNode namenode, String path) {
        return namenode.getNamesystem().leaseManager.getLeaseByPath(path).getHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatanodeDescriptor getDatanode(FSNamesystem ns, DatanodeID id) throws IOException {
        ns.readLock();
        try {
            DatanodeDescriptor datanodeDescriptor = ns.getBlockManager().getDatanodeManager().getDatanode(id);
            return datanodeDescriptor;
        }
        finally {
            ns.readUnlock();
        }
    }

    public static int getSafeModeSafeBlocks(NameNode nn) {
        FSNamesystem.SafeModeInfo smi = nn.getNamesystem().getSafeModeInfoForTests();
        if (smi == null) {
            return -1;
        }
        return smi.blockSafe;
    }

    public static boolean safeModeInitializedReplQueues(NameNode nn) {
        FSNamesystem.SafeModeInfo smi = nn.getNamesystem().getSafeModeInfoForTests();
        if (smi == null) {
            return true;
        }
        return smi.initializedReplQueues;
    }
}

