/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileNameGenerator;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;

public class CreateEditsLog {
    static final String BASE_PATH = "/createdViaInjectingInEditsLog";
    static final String EDITS_DIR = "/tmp/EditsLogOut";
    static String edits_dir = "/tmp/EditsLogOut";
    public static final long BLOCK_GENERATION_STAMP = 1000L;
    static String usage = "Usage: createditlogs  -f  numFiles startingBlockIds NumBlocksPerFile  [-r replicafactor] [-d editsLogDirectory]\n      Default replication factor is 1\n      Default edits log direcory is /tmp/EditsLogOut\n";

    static void addFiles(FSEditLog editLog, int numFiles, short replication, int blocksPerFile, long startingBlockId, FileNameGenerator nameGenerator) {
        PermissionStatus p = new PermissionStatus("joeDoe", "people", new FsPermission(511));
        INodeDirectory dirInode = new INodeDirectory(p, 0L);
        editLog.logMkDir(BASE_PATH, (INode)dirInode);
        long blockSize = 10L;
        BlockInfo[] blocks = new BlockInfo[blocksPerFile];
        for (int iB = 0; iB < blocksPerFile; ++iB) {
            blocks[iB] = new BlockInfo(new Block(0L, blockSize, 1000L), (int)replication);
        }
        long currentBlockId = startingBlockId;
        long bidAtSync = startingBlockId;
        for (int iF = 0; iF < numFiles; ++iF) {
            for (int iB = 0; iB < blocksPerFile; ++iB) {
                blocks[iB].setBlockId(currentBlockId++);
            }
            INodeFileUnderConstruction inode = new INodeFileUnderConstruction(null, replication, 0L, blockSize, blocks, p, "", "", null);
            String path = "_" + iF + "_B" + blocks[0].getBlockId() + "_to_B" + blocks[blocksPerFile - 1].getBlockId() + "_";
            String filePath = nameGenerator.getNextFileName("");
            filePath = filePath + path;
            if (iF % nameGenerator.getFilesPerDirectory() == 0) {
                String currentDir = nameGenerator.getCurrentDir();
                dirInode = new INodeDirectory(p, 0L);
                editLog.logMkDir(currentDir, (INode)dirInode);
            }
            editLog.logOpenFile(filePath, new INodeFileUnderConstruction(p, replication, 0L, blockSize, "", "", null));
            editLog.logCloseFile(filePath, (INodeFile)inode);
            if (currentBlockId - bidAtSync < 2000L) continue;
            editLog.logSync();
            bidAtSync = currentBlockId;
        }
        System.out.println("Created edits log in directory " + edits_dir);
        System.out.println(" containing " + numFiles + " File-Creates, each file with " + blocksPerFile + " blocks");
        System.out.println(" blocks range: " + startingBlockId + " to " + (currentBlockId - 1L));
    }

    static void printUsageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    static void printUsageExit(String err) {
        System.out.println(err);
        CreateEditsLog.printUsageExit();
    }

    public static void main(String[] args) throws IOException {
        long startingBlockId = 1L;
        int numFiles = 0;
        short replication = 1;
        int numBlocksPerFile = 0;
        if (args.length == 0) {
            CreateEditsLog.printUsageExit();
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                CreateEditsLog.printUsageExit();
            }
            if (args[i].equals("-f")) {
                if (i + 3 >= args.length || args[i + 1].startsWith("-") || args[i + 2].startsWith("-") || args[i + 3].startsWith("-")) {
                    CreateEditsLog.printUsageExit("Missing num files, starting block and/or number of blocks");
                }
                numFiles = Integer.parseInt(args[++i]);
                startingBlockId = Integer.parseInt(args[++i]);
                numBlocksPerFile = Integer.parseInt(args[++i]);
                if (numFiles > 0 && numBlocksPerFile > 0) continue;
                CreateEditsLog.printUsageExit("numFiles and numBlocksPerFile most be greater than 0");
                continue;
            }
            if (args[i].equals("-r") || args[i + 1].startsWith("-")) {
                if (i + 1 >= args.length) {
                    CreateEditsLog.printUsageExit("Missing num files, starting block and/or number of blocks");
                }
                replication = Short.parseShort(args[++i]);
                continue;
            }
            if (args[i].equals("-d")) {
                if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
                    CreateEditsLog.printUsageExit("Missing edits logs directory");
                }
                edits_dir = args[++i];
                continue;
            }
            CreateEditsLog.printUsageExit();
        }
        File editsLogDir = new File(edits_dir);
        File subStructureDir = new File(edits_dir + "/" + "current");
        if (!editsLogDir.exists() && !editsLogDir.mkdir()) {
            System.out.println("cannot create " + edits_dir);
            System.exit(-1);
        }
        if (!subStructureDir.exists() && !subStructureDir.mkdir()) {
            System.out.println("cannot create subdirs of " + edits_dir);
            System.exit(-1);
        }
        FileNameGenerator nameGenerator = new FileNameGenerator(BASE_PATH, 100);
        FSEditLog editLog = FSImageTestUtil.createStandaloneEditLog(editsLogDir);
        editLog.open();
        CreateEditsLog.addFiles(editLog, numFiles, replication, numBlocksPerFile, startingBlockId, nameGenerator);
        editLog.logSync();
        editLog.close();
    }
}

