/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hdfs.server.datanode.FSDatasetInterface;
import org.apache.hadoop.hdfs.server.datanode.RoundRobinVolumesPolicy;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRoundRobinVolumesPolicy {
    @Test
    public void testRR() throws Exception {
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(Mockito.mock(FSDatasetInterface.FSVolumeInterface.class));
        Mockito.when((Object)((FSDatasetInterface.FSVolumeInterface)volumes.get(0)).getAvailable()).thenReturn((Object)100L);
        volumes.add(Mockito.mock(FSDatasetInterface.FSVolumeInterface.class));
        Mockito.when((Object)((FSDatasetInterface.FSVolumeInterface)volumes.get(1)).getAvailable()).thenReturn((Object)200L);
        RoundRobinVolumesPolicy policy = (RoundRobinVolumesPolicy)ReflectionUtils.newInstance(RoundRobinVolumesPolicy.class, null);
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(0), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 0L));
        Assert.assertEquals(volumes.get(1), (Object)policy.chooseVolume(volumes, 150L));
        try {
            policy.chooseVolume(volumes, Long.MAX_VALUE);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRRPolicyExceptionMessage() throws Exception {
        ArrayList<Object> volumes = new ArrayList<Object>();
        volumes.add(Mockito.mock(FSDatasetInterface.FSVolumeInterface.class));
        Mockito.when((Object)((FSDatasetInterface.FSVolumeInterface)volumes.get(0)).getAvailable()).thenReturn((Object)500L);
        volumes.add(Mockito.mock(FSDatasetInterface.FSVolumeInterface.class));
        Mockito.when((Object)((FSDatasetInterface.FSVolumeInterface)volumes.get(1)).getAvailable()).thenReturn((Object)600L);
        RoundRobinVolumesPolicy policy = new RoundRobinVolumesPolicy();
        int blockSize = 700;
        try {
            policy.chooseVolume(volumes, (long)blockSize);
            Assert.fail((String)"expected to throw DiskOutOfSpaceException");
        }
        catch (DiskChecker.DiskOutOfSpaceException e) {
            Assert.assertEquals((String)"Not returnig the expected message", (Object)("Insufficient space for an additional block. Volume with the most available space has 600 bytes free, configured block size is " + blockSize), (Object)e.getMessage());
        }
    }
}

