/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.Assert;
import org.junit.Test;

public class TestRefreshNamenodes {
    private int nnPort1 = 2221;
    private int nnPort2 = 2224;
    private int nnPort3 = 2227;
    private int nnPort4 = 2230;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRefreshNamenodes() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            conf.set("dfs.federation.nameservices", "namesServerId1");
            cluster = new MiniDFSCluster.Builder(conf).federation(true).numNameNodes(1).nameNodePort(this.nnPort1).build();
            DataNode dn = cluster.getDataNodes().get(0);
            Assert.assertEquals((long)1L, (long)dn.getAllBpOs().length);
            cluster.addNameNode(conf, this.nnPort2);
            Assert.assertEquals((long)2L, (long)dn.getAllBpOs().length);
            cluster.addNameNode(conf, this.nnPort3);
            Assert.assertEquals((long)3L, (long)dn.getAllBpOs().length);
            cluster.addNameNode(conf, this.nnPort4);
            BPOfferService[] bpoList = dn.getAllBpOs();
            for (int i = 0; i < 4; ++i) {
                InetSocketAddress addr = cluster.getNameNode(i).getNameNodeAddress();
                boolean found = false;
                for (int j = 0; j < bpoList.length; ++j) {
                    if (bpoList[j] == null || !addr.equals(bpoList[j].nnAddr)) continue;
                    found = true;
                    bpoList[j] = null;
                    break;
                }
                Assert.assertTrue((String)("NameNode address " + addr + " is not found."), (boolean)found);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

