/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDatanodeRegister {
    public static final Log LOG = LogFactory.getLog(TestDatanodeRegister.class);
    static final InetSocketAddress INVALID_ADDR = new InetSocketAddress("127.0.0.1", 1);

    @Test
    public void testDataNodeRegister() throws Exception {
        DataNode mockDN = (DataNode)Mockito.mock(DataNode.class);
        ((DataNode)Mockito.doReturn((Object)true).when((Object)mockDN)).shouldRun();
        BPOfferService bpos = new BPOfferService(INVALID_ADDR, mockDN);
        NamespaceInfo fakeNSInfo = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        Mockito.when((Object)fakeNSInfo.getBuildVersion()).thenReturn((Object)"NSBuildVersion");
        DatanodeProtocol fakeDNProt = (DatanodeProtocol)Mockito.mock(DatanodeProtocol.class);
        Mockito.when((Object)fakeDNProt.versionRequest()).thenReturn((Object)fakeNSInfo);
        bpos.setNameNode(fakeDNProt);
        bpos.bpNSInfo = fakeNSInfo;
        try {
            bpos.retrieveNamespaceInfo();
            Assert.fail((String)"register() did not throw exception! Expected: IncorrectVersionException");
        }
        catch (IncorrectVersionException ie) {
            LOG.info((Object)"register() returned correct Exception: IncorrectVersionException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeReregister() throws Exception {
        String hostname = "somehostname";
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.defaultFS", "127.0.0.1:0");
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        conf.set("dfs.datanode.hostname", "somehostname");
        DataNode dn = new DataNode((Configuration)conf, null);
        try {
            NamespaceInfo fakeNSInfo = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
            Mockito.when((Object)fakeNSInfo.getBuildVersion()).thenReturn((Object)"NSBuildVersion");
            DatanodeRegistration bpReg = dn.createBPRegistration(fakeNSInfo);
            Assert.assertEquals((String)"Bad hostname in registration", (Object)"somehostname", (Object)bpReg.getHost());
            bpReg.setName("127.0.0.1:0");
            dn.bpRegistrationSucceeded(bpReg, null);
            bpReg = dn.createBPRegistration(fakeNSInfo);
            Assert.assertEquals((String)"Bad hostname in re-registration", (Object)"somehostname", (Object)bpReg.getHost());
        }
        finally {
            dn.shutdown();
        }
    }
}

