/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.server.datanode.DatanodeJspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.ServletUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDatanodeJsp {
    private static final String FILE_DATA = "foo bar baz biz buz";
    private static final HdfsConfiguration CONF = new HdfsConfiguration();

    private static void testViewingFile(MiniDFSCluster cluster, String filePath, boolean doTail) throws IOException {
        Path testPath;
        FileSystem fs = cluster.getFileSystem();
        if (!fs.exists(testPath = new Path(filePath))) {
            DFSTestUtil.writeFile(fs, testPath, FILE_DATA);
        }
        InetSocketAddress nnIpcAddress = cluster.getNameNode().getNameNodeAddress();
        InetSocketAddress nnHttpAddress = cluster.getNameNode().getHttpAddress();
        int dnInfoPort = cluster.getDataNodes().get(0).getInfoPort();
        String jspName = doTail ? "tail.jsp" : "browseDirectory.jsp";
        String fileParamName = doTail ? "filename" : "dir";
        URL url = new URL("http://localhost:" + dnInfoPort + "/" + jspName + JspHelper.getUrlParam((String)fileParamName, (String)URLEncoder.encode(testPath.toString(), "UTF-8"), (boolean)true) + JspHelper.getUrlParam((String)"namenodeInfoPort", (String)Integer.toString(nnHttpAddress.getPort())) + JspHelper.getUrlParam((String)"nnaddr", (String)("localhost:" + nnIpcAddress.getPort())));
        String viewFilePage = DFSTestUtil.urlGet(url);
        Assert.assertTrue((String)("page should show preview of file contents, got: " + viewFilePage), (boolean)viewFilePage.contains(FILE_DATA));
        if (!doTail) {
            Assert.assertTrue((String)"page should show link to download file", (boolean)viewFilePage.contains("/streamFile" + ServletUtil.encodePath((String)testPath.toString()) + "?nnaddr=localhost:" + nnIpcAddress.getPort()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewFileJsp() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            String[] paths;
            cluster = new MiniDFSCluster.Builder((Configuration)CONF).build();
            cluster.waitActive();
            for (String p : paths = new String[]{"/test-file", "/tmp/test-file", "/tmp/test-file%with goofy&characters", "/foo bar/foo bar", "/foo+bar/foo+bar", "/foo;bar/foo;bar", "/foo=bar/foo=bar", "/foo,bar/foo,bar", "/foo?bar/foo?bar", "/foo\">bar/foo\">bar"}) {
                TestDatanodeJsp.testViewingFile(cluster, p, false);
                TestDatanodeJsp.testViewingFile(cluster, p, true);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenStamp() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(1).build();
        try {
            FileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/test/mkdirs/TestchunkSizeToView");
            TestDatanodeJsp.writeFile(fs, testFile);
            JspWriter writerMock = (JspWriter)Mockito.mock(JspWriter.class);
            HttpServletRequest reqMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            this.setTheMockExpectationsFromReq(testFile, reqMock);
            DatanodeJspHelper.generateFileDetails((JspWriter)writerMock, (HttpServletRequest)reqMock, (Configuration)CONF);
            ((JspWriter)Mockito.verify((Object)writerMock, (VerificationMode)Mockito.atLeastOnce())).print("<input type=\"hidden\" name=\"genstamp\" value=\"987654321\">");
        }
        finally {
            cluster.shutdown();
        }
    }

    private void setTheMockExpectationsFromReq(Path testFile, HttpServletRequest reqMock) {
        ((HttpServletRequest)Mockito.doReturn((Object)"987654321").when((Object)reqMock)).getParameter("genstamp");
        ((HttpServletRequest)Mockito.doReturn((Object)"1234").when((Object)reqMock)).getParameter("blockId");
        ((HttpServletRequest)Mockito.doReturn((Object)"8081").when((Object)reqMock)).getParameter("datanodePort");
        ((HttpServletRequest)Mockito.doReturn((Object)"8080").when((Object)reqMock)).getParameter("namenodeInfoPort");
        ((HttpServletRequest)Mockito.doReturn((Object)"100").when((Object)reqMock)).getParameter("chunkSizeToView");
        ((HttpServletRequest)Mockito.doReturn((Object)"1").when((Object)reqMock)).getParameter("startOffset");
        ((HttpServletRequest)Mockito.doReturn((Object)"1024").when((Object)reqMock)).getParameter("blockSize");
        ((HttpServletRequest)Mockito.doReturn((Object)NameNode.getHostPortString((InetSocketAddress)NameNode.getAddress((Configuration)CONF))).when((Object)reqMock)).getParameter("nnaddr");
        ((HttpServletRequest)Mockito.doReturn((Object)testFile.toString()).when((Object)reqMock)).getPathInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        try {
            out.writeBytes("umamahesh: " + f);
        }
        finally {
            out.close();
        }
        Assert.assertTrue((boolean)fs.exists(f));
        return f;
    }
}

