/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;

public class DataNodeTestUtils {
    public static DatanodeRegistration getDNRegistrationByMachineName(DataNode dn, String mName) {
        return dn.getDNRegistrationByMachineName(mName);
    }

    public static void triggerHeartbeat(DataNode dn) throws IOException {
        for (BPOfferService bpos : dn.getAllBpOs()) {
            bpos.triggerHeartbeatForTests();
        }
    }

    public static DatanodeRegistration getDNRegistrationForBP(DataNode dn, String bpid) throws IOException {
        return dn.getDNRegistrationForBP(bpid);
    }

    public static File getFile(DataNode dn, String bpid, long bid) {
        return ((FSDataset)dn.getFSDataset()).getFile(bpid, bid);
    }

    public static File getBlockFile(DataNode dn, String bpid, Block b) throws IOException {
        return ((FSDataset)dn.getFSDataset()).getBlockFile(bpid, b);
    }

    public static boolean unlinkBlock(DataNode dn, ExtendedBlock block, int numLinks) throws IOException {
        ReplicaInfo info = ((FSDataset)dn.getFSDataset()).getReplicaInfo(block);
        return info.unlinkBlock(numLinks);
    }
}

