/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FSDataset;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.test.GenericTestUtils;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DataNodeAdapter {
    public static ReplicaInfo fetchReplicaInfo(DataNode dn, String bpid, long blkId) {
        return ((FSDataset)dn.data).fetchReplicaInfo(bpid, blkId);
    }

    public static void setHeartbeatsDisabledForTests(DataNode dn, boolean heartbeatsDisabledForTests) {
        dn.setHeartbeatsDisabledForTests(heartbeatsDisabledForTests);
    }

    public static DatanodeProtocol spyOnBposToNN(DataNode dn, NameNode nn) {
        String bpid = nn.getNamesystem().getBlockPoolId();
        BPOfferService bpos = null;
        for (BPOfferService thisBpos : dn.getAllBpOs()) {
            if (!thisBpos.getBlockPoolId().equals(bpid)) continue;
            bpos = thisBpos;
            break;
        }
        Preconditions.checkArgument((bpos != null ? 1 : 0) != 0, (String)"No such bpid: %s", (Object[])new Object[]{bpid});
        DatanodeProtocol origNN = bpos.getBpNamenode();
        DatanodeProtocol spy = (DatanodeProtocol)Mockito.mock(DatanodeProtocol.class, (Answer)new GenericTestUtils.DelegateAnswer((Object)origNN));
        bpos.setBpNamenode(spy);
        return spy;
    }
}

