/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.hdfs.server.common.StorageInfo;

public class TestStorageInfo
extends TestCase {
    public void testStorageInfo() throws IOException {
        int nsID = 123;
        String cid = "cid-test";
        int layoutV = 234;
        long cT = 0L;
        StorageInfo sinfo = new StorageInfo(layoutV, nsID, cid, cT);
        Assert.assertNotNull((Object)sinfo);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bos);
        try {
            sinfo.write((DataOutput)output);
            bos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            DataInputStream dataInputStream = new DataInputStream(bis);
            StorageInfo secondsinfo = new StorageInfo();
            secondsinfo.readFields((DataInput)dataInputStream);
            Assert.assertEquals((String)sinfo.getClusterID(), (String)secondsinfo.getClusterID());
            Assert.assertEquals((int)sinfo.getNamespaceID(), (int)secondsinfo.getNamespaceID());
            Assert.assertEquals((int)sinfo.getLayoutVersion(), (int)secondsinfo.getLayoutVersion());
            Assert.assertEquals((long)sinfo.getCTime(), (long)secondsinfo.getCTime());
        }
        catch (IOException e) {
            e.getMessage();
        }
    }
}

