/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDatanodeBlockScanner;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;

public class TestOverReplicatedBlocks
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProcesOverReplicateBlock() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        FileSystem fs = cluster.getFileSystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile(fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication(fs, fileName, (short)3);
            ExtendedBlock block = DFSTestUtil.getFirstBlock(fs, fileName);
            TestOverReplicatedBlocks.assertTrue((boolean)TestDatanodeBlockScanner.corruptReplica(block, 0));
            MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
            File scanLog = new File(MiniDFSCluster.getFinalizedDir(cluster.getInstanceStorageDir(0, 0), cluster.getNamesystem().getBlockPoolId()).getParent().toString() + "/../dncp_block_verification.log.prev");
            int i = 0;
            while (!scanLog.delete()) {
                TestOverReplicatedBlocks.assertTrue((String)"Could not delete log file in one minute", (i < 60 ? 1 : 0) != 0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ++i;
            }
            cluster.restartDataNode(dnProps);
            DFSTestUtil.waitReplication(fs, fileName, (short)2);
            String blockPoolId = cluster.getNamesystem().getBlockPoolId();
            DatanodeRegistration corruptDataNode = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(2), blockPoolId);
            FSNamesystem namesystem = cluster.getNamesystem();
            BlockManager bm = namesystem.getBlockManager();
            HeartbeatManager hm = bm.getDatanodeManager().getHeartbeatManager();
            try {
                namesystem.writeLock();
                HeartbeatManager heartbeatManager = hm;
                synchronized (heartbeatManager) {
                    String corruptMachineName = corruptDataNode.getName();
                    for (DatanodeDescriptor datanode : hm.getDatanodes()) {
                        if (corruptMachineName.equals(datanode.getName())) continue;
                        datanode.updateHeartbeat(100L, 100L, 0L, 100L, 0, 0);
                    }
                    NameNodeAdapter.setReplication(namesystem, fileName.toString(), (short)1);
                    TestOverReplicatedBlocks.assertEquals((int)1, (int)bm.countNodes(block.getLocalBlock()).liveReplicas());
                }
            }
            finally {
                namesystem.writeUnlock();
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

