/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.HeartbeatManager;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;

public class TestHeartbeatHandling
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHeartbeat() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            HeartbeatManager hm = namesystem.getBlockManager().getDatanodeManager().getHeartbeatManager();
            String poolId = namesystem.getBlockPoolId();
            DatanodeRegistration nodeReg = DataNodeTestUtils.getDNRegistrationForBP(cluster.getDataNodes().get(0), poolId);
            DatanodeDescriptor dd = NameNodeAdapter.getDatanode(namesystem, (DatanodeID)nodeReg);
            boolean REMAINING_BLOCKS = true;
            int MAX_REPLICATE_LIMIT = conf.getInt("dfs.namenode.replication.max-streams", 2);
            int MAX_INVALIDATE_LIMIT = 1000;
            int MAX_INVALIDATE_BLOCKS = 2001;
            int MAX_REPLICATE_BLOCKS = 2 * MAX_REPLICATE_LIMIT + 1;
            DatanodeDescriptor[] ONE_TARGET = new DatanodeDescriptor[1];
            try {
                namesystem.writeLock();
                HeartbeatManager heartbeatManager = hm;
                synchronized (heartbeatManager) {
                    for (int i = 0; i < MAX_REPLICATE_BLOCKS; ++i) {
                        dd.addBlockToBeReplicated(new Block((long)i, 0L, 1000L), ONE_TARGET);
                    }
                    DatanodeCommand[] cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem);
                    TestHeartbeatHandling.assertEquals((int)1, (int)cmds.length);
                    TestHeartbeatHandling.assertEquals((int)1, (int)cmds[0].getAction());
                    TestHeartbeatHandling.assertEquals((int)MAX_REPLICATE_LIMIT, (int)((BlockCommand)cmds[0]).getBlocks().length);
                    ArrayList<Block> blockList = new ArrayList<Block>(2001);
                    for (int i = 0; i < 2001; ++i) {
                        blockList.add(new Block((long)i, 0L, 1000L));
                    }
                    dd.addBlocksToBeInvalidated(blockList);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem);
                    TestHeartbeatHandling.assertEquals((int)2, (int)cmds.length);
                    TestHeartbeatHandling.assertEquals((int)1, (int)cmds[0].getAction());
                    TestHeartbeatHandling.assertEquals((int)MAX_REPLICATE_LIMIT, (int)((BlockCommand)cmds[0]).getBlocks().length);
                    TestHeartbeatHandling.assertEquals((int)2, (int)cmds[1].getAction());
                    TestHeartbeatHandling.assertEquals((int)1000, (int)((BlockCommand)cmds[1]).getBlocks().length);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem);
                    TestHeartbeatHandling.assertEquals((int)2, (int)cmds.length);
                    TestHeartbeatHandling.assertEquals((int)1, (int)cmds[0].getAction());
                    TestHeartbeatHandling.assertEquals((int)1, (int)((BlockCommand)cmds[0]).getBlocks().length);
                    TestHeartbeatHandling.assertEquals((int)2, (int)cmds[1].getAction());
                    TestHeartbeatHandling.assertEquals((int)1000, (int)((BlockCommand)cmds[1]).getBlocks().length);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem);
                    TestHeartbeatHandling.assertEquals((int)1, (int)cmds.length);
                    TestHeartbeatHandling.assertEquals((int)2, (int)cmds[0].getAction());
                    TestHeartbeatHandling.assertEquals((int)1, (int)((BlockCommand)cmds[0]).getBlocks().length);
                    cmds = NameNodeAdapter.sendHeartBeat(nodeReg, dd, namesystem);
                    TestHeartbeatHandling.assertEquals(null, (Object)cmds);
                }
            }
            finally {
                namesystem.writeUnlock();
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

