/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;

public class TestDatanodeDescriptor
extends TestCase {
    public void testGetInvalidateBlocks() throws Exception {
        int MAX_BLOCKS = 10;
        int REMAINING_BLOCKS = 2;
        int MAX_LIMIT = 8;
        DatanodeDescriptor dd = new DatanodeDescriptor();
        ArrayList<Block> blockList = new ArrayList<Block>(10);
        for (int i = 0; i < 10; ++i) {
            blockList.add(new Block((long)i, 0L, 1000L));
        }
        dd.addBlocksToBeInvalidated(blockList);
        Block[] bc = dd.getInvalidateBlocks(8);
        TestDatanodeDescriptor.assertEquals((int)bc.length, (int)8);
        bc = dd.getInvalidateBlocks(8);
        TestDatanodeDescriptor.assertEquals((int)bc.length, (int)2);
    }

    public void testBlocksCounter() throws Exception {
        DatanodeDescriptor dd = new DatanodeDescriptor();
        TestDatanodeDescriptor.assertEquals((int)0, (int)dd.numBlocks());
        BlockInfo blk = new BlockInfo(new Block(1L), 1);
        BlockInfo blk1 = new BlockInfo(new Block(2L), 2);
        TestDatanodeDescriptor.assertTrue((boolean)dd.addBlock(blk));
        TestDatanodeDescriptor.assertEquals((int)1, (int)dd.numBlocks());
        TestDatanodeDescriptor.assertFalse((boolean)dd.removeBlock(blk1));
        TestDatanodeDescriptor.assertEquals((int)1, (int)dd.numBlocks());
        TestDatanodeDescriptor.assertFalse((boolean)dd.addBlock(blk));
        TestDatanodeDescriptor.assertEquals((int)1, (int)dd.numBlocks());
        TestDatanodeDescriptor.assertTrue((boolean)dd.addBlock(blk1));
        TestDatanodeDescriptor.assertEquals((int)2, (int)dd.numBlocks());
        TestDatanodeDescriptor.assertTrue((boolean)dd.removeBlock(blk));
        TestDatanodeDescriptor.assertEquals((int)1, (int)dd.numBlocks());
        TestDatanodeDescriptor.assertTrue((boolean)dd.removeBlock(blk1));
        TestDatanodeDescriptor.assertEquals((int)0, (int)dd.numBlocks());
    }
}

