/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockPoolTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslInputStream;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestBlockToken {
    public static final Log LOG = LogFactory.getLog(TestBlockToken.class);
    private static final String ADDRESS = "0.0.0.0";
    static final String SERVER_PRINCIPAL_KEY = "test.ipc.server.principal";
    private static Configuration conf = new Configuration();
    static File FD_DIR;
    long blockKeyUpdateInterval = 600000L;
    long blockTokenLifetime = 120000L;
    ExtendedBlock block1 = new ExtendedBlock("0", 0L);
    ExtendedBlock block2 = new ExtendedBlock("10", 10L);
    ExtendedBlock block3 = new ExtendedBlock("-10", -108L);

    private BlockTokenIdentifier generateTokenId(BlockTokenSecretManager sm, ExtendedBlock block, EnumSet<BlockTokenSecretManager.AccessMode> accessModes) throws IOException {
        Token token = sm.generateToken(block, accessModes);
        BlockTokenIdentifier id = sm.createIdentifier();
        id.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        return id;
    }

    @Test
    public void testWritable() throws Exception {
        TestWritable.testWritable((Writable)new BlockTokenIdentifier());
        BlockTokenSecretManager sm = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block1, EnumSet.allOf(BlockTokenSecretManager.AccessMode.class)));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block2, EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
        TestWritable.testWritable((Writable)this.generateTokenId(sm, this.block3, EnumSet.noneOf(BlockTokenSecretManager.AccessMode.class)));
    }

    private void tokenGenerationAndVerification(BlockTokenSecretManager master, BlockTokenSecretManager slave) throws Exception {
        for (BlockTokenSecretManager.AccessMode mode : BlockTokenSecretManager.AccessMode.values()) {
            Token token1 = master.generateToken(this.block1, EnumSet.of(mode));
            master.checkAccess(token1, null, this.block1, mode);
            slave.checkAccess(token1, null, this.block1, mode);
            Token token2 = slave.generateToken(this.block2, EnumSet.of(mode));
            master.checkAccess(token2, null, this.block2, mode);
            slave.checkAccess(token2, null, this.block2, mode);
        }
        Token mtoken = master.generateToken(this.block3, EnumSet.allOf(BlockTokenSecretManager.AccessMode.class));
        for (BlockTokenSecretManager.AccessMode mode : BlockTokenSecretManager.AccessMode.values()) {
            master.checkAccess(mtoken, null, this.block3, mode);
            slave.checkAccess(mtoken, null, this.block3, mode);
        }
    }

    @Test
    public void testBlockTokenSecretManager() throws Exception {
        BlockTokenSecretManager masterHandler = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        BlockTokenSecretManager slaveHandler = new BlockTokenSecretManager(false, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        ExportedBlockKeys keys = masterHandler.exportKeys();
        slaveHandler.setKeys(keys);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler);
        masterHandler.updateKeys();
        this.tokenGenerationAndVerification(masterHandler, slaveHandler);
        keys = masterHandler.exportKeys();
        slaveHandler.setKeys(keys);
        this.tokenGenerationAndVerification(masterHandler, slaveHandler);
    }

    private Server createMockDatanode(BlockTokenSecretManager sm, Token<BlockTokenIdentifier> token) throws IOException {
        ClientDatanodeProtocol mockDN = (ClientDatanodeProtocol)Mockito.mock(ClientDatanodeProtocol.class);
        Mockito.when((Object)mockDN.getProtocolVersion(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)9L);
        ((ClientDatanodeProtocol)Mockito.doReturn((Object)ProtocolSignature.getProtocolSignature((VersionedProtocol)mockDN, (String)ClientDatanodeProtocol.class.getName(), (long)9L, (int)0)).when((Object)mockDN)).getProtocolSignature(Matchers.anyString(), Matchers.anyLong(), Matchers.anyInt());
        BlockTokenIdentifier id = sm.createIdentifier();
        id.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        ((ClientDatanodeProtocol)Mockito.doAnswer((Answer)new getLengthAnswer(sm, id)).when((Object)mockDN)).getReplicaVisibleLength((ExtendedBlock)Matchers.any(ExtendedBlock.class));
        return RPC.getServer(ClientDatanodeProtocol.class, (Object)mockDN, (String)ADDRESS, (int)0, (int)5, (boolean)true, (Configuration)conf, (SecretManager)sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockTokenRpc() throws Exception {
        BlockTokenSecretManager sm = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        Token token = sm.generateToken(this.block3, EnumSet.allOf(BlockTokenSecretManager.AccessMode.class));
        Server server = this.createMockDatanode(sm, (Token<BlockTokenIdentifier>)token);
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser((String)this.block3.toString());
        ticket.addToken(token);
        ClientDatanodeProtocol proxy = null;
        try {
            proxy = (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, (long)9L, (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf));
            Assert.assertEquals((long)this.block3.getBlockId(), (long)proxy.getReplicaVisibleLength(this.block3));
        }
        catch (Throwable throwable) {
            server.stop();
            if (proxy != null) {
                RPC.stopProxy(proxy);
            }
            throw throwable;
        }
        server.stop();
        if (proxy != null) {
            RPC.stopProxy((Object)proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockTokenRpcLeak() throws Exception {
        Assume.assumeTrue((boolean)FD_DIR.exists());
        BlockTokenSecretManager sm = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        Token token = sm.generateToken(this.block3, EnumSet.allOf(BlockTokenSecretManager.AccessMode.class));
        Server server = this.createMockDatanode(sm, (Token<BlockTokenIdentifier>)token);
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        DatanodeID fakeDnId = new DatanodeID("localhost:" + addr.getPort(), "fake-storage", 0, addr.getPort());
        ExtendedBlock b = new ExtendedBlock("fake-pool", new Block(12345L));
        LocatedBlock fakeBlock = new LocatedBlock(b, new DatanodeInfo[0]);
        fakeBlock.setBlockToken(token);
        ClientDatanodeProtocol proxyToNoWhere = (ClientDatanodeProtocol)RPC.getProxy(ClientDatanodeProtocol.class, (long)9L, (InetSocketAddress)new InetSocketAddress("1.1.1.1", 1), (UserGroupInformation)UserGroupInformation.createRemoteUser((String)"junk"), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf));
        ClientDatanodeProtocol proxy = null;
        int fdsAtStart = TestBlockToken.countOpenFileDescriptors();
        try {
            long endTime = System.currentTimeMillis() + 3000L;
            while (System.currentTimeMillis() < endTime) {
                proxy = DFSUtil.createClientDatanodeProtocolProxy((DatanodeID)fakeDnId, (Configuration)conf, (int)1000, (LocatedBlock)fakeBlock);
                Assert.assertEquals((long)this.block3.getBlockId(), (long)proxy.getReplicaVisibleLength(this.block3));
                if (proxy != null) {
                    RPC.stopProxy((Object)proxy);
                }
                LOG.info((Object)("Num open fds:" + TestBlockToken.countOpenFileDescriptors()));
            }
            int fdsAtEnd = TestBlockToken.countOpenFileDescriptors();
            if (fdsAtEnd - fdsAtStart > 50) {
                Assert.fail((String)("Leaked " + (fdsAtEnd - fdsAtStart) + " fds!"));
            }
        }
        finally {
            server.stop();
        }
        RPC.stopProxy((Object)proxyToNoWhere);
    }

    private static int countOpenFileDescriptors() throws IOException {
        return FD_DIR.list().length;
    }

    @Test
    public void testBlockPoolTokenSecretManager() throws Exception {
        BlockPoolTokenSecretManager bpMgr = new BlockPoolTokenSecretManager();
        for (int i = 0; i < 10; ++i) {
            String bpid = Integer.toString(i);
            BlockTokenSecretManager masterHandler = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
            BlockTokenSecretManager slaveHandler = new BlockTokenSecretManager(false, this.blockKeyUpdateInterval, this.blockTokenLifetime);
            bpMgr.addBlockPool(bpid, slaveHandler);
            ExportedBlockKeys keys = masterHandler.exportKeys();
            bpMgr.setKeys(bpid, keys);
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid));
            masterHandler.updateKeys();
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid));
            keys = masterHandler.exportKeys();
            bpMgr.setKeys(bpid, keys);
            this.tokenGenerationAndVerification(masterHandler, bpMgr.get(bpid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockTokenInLastLocatedBlock() throws IOException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setInt("dfs.blocksize", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numNameNodes(1).numDataNodes(1).build();
        cluster.waitActive();
        try {
            FileSystem fs = cluster.getFileSystem();
            String fileName = "/testBlockTokenInLastLocatedBlock";
            Path filePath = new Path(fileName);
            FSDataOutputStream out = fs.create(filePath, (short)1);
            out.write(new byte[1000]);
            LocatedBlocks locatedBlocks = cluster.getNameNodeRpc().getBlockLocations(fileName, 0L, 1000L);
            while (locatedBlocks.getLastLocatedBlock() == null) {
                Thread.sleep(100L);
                locatedBlocks = cluster.getNameNodeRpc().getBlockLocations(fileName, 0L, 1000L);
            }
            Token token = locatedBlocks.getLastLocatedBlock().getBlockToken();
            Assert.assertEquals((Object)BlockTokenIdentifier.KIND_NAME, (Object)token.getKind());
            out.close();
        }
        finally {
            cluster.shutdown();
        }
    }

    static {
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        ((Log4JLogger)Client.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)Server.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslRpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)SaslInputStream.LOG).getLogger().setLevel(Level.ALL);
        FD_DIR = new File("/proc/self/fd/");
    }

    private static class getLengthAnswer
    implements Answer<Long> {
        BlockTokenSecretManager sm;
        BlockTokenIdentifier ident;

        public getLengthAnswer(BlockTokenSecretManager sm, BlockTokenIdentifier ident) {
            this.sm = sm;
            this.ident = ident;
        }

        public Long answer(InvocationOnMock invocation) throws IOException {
            Object[] args = invocation.getArguments();
            Assert.assertEquals((long)1L, (long)args.length);
            ExtendedBlock block = (ExtendedBlock)args[0];
            Set tokenIds = UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            Assert.assertEquals((String)"Only one BlockTokenIdentifier expected", (long)1L, (long)tokenIds.size());
            long result = 0L;
            for (TokenIdentifier tokenId : tokenIds) {
                BlockTokenIdentifier id = (BlockTokenIdentifier)tokenId;
                LOG.info((Object)("Got: " + id.toString()));
                Assert.assertTrue((String)"Received BlockTokenIdentifier is wrong", (boolean)this.ident.equals((Object)id));
                this.sm.checkAccess(id, null, block, BlockTokenSecretManager.AccessMode.WRITE);
                result = id.getBlockId();
            }
            return result;
        }
    }
}

