/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.EnumSet;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.junit.Assert;
import org.junit.Test;

public class TestLayoutVersion {
    @Test
    public void testFeaturesFromAncestorSupported() {
        for (LayoutVersion.Feature f : LayoutVersion.Feature.values()) {
            this.validateFeatureList(f);
        }
    }

    @Test
    public void testRelease203() {
        Assert.assertTrue((boolean)LayoutVersion.supports((LayoutVersion.Feature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_203.lv));
    }

    @Test
    public void testRelease204() {
        Assert.assertTrue((boolean)LayoutVersion.supports((LayoutVersion.Feature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_204.lv));
    }

    private void validateFeatureList(LayoutVersion.Feature f) {
        int lv = f.lv;
        int ancestorLV = f.ancestorLV;
        EnumSet ancestorSet = (EnumSet)LayoutVersion.map.get(ancestorLV);
        Assert.assertNotNull((Object)ancestorSet);
        for (LayoutVersion.Feature feature : ancestorSet) {
            Assert.assertTrue((boolean)LayoutVersion.supports((LayoutVersion.Feature)feature, (int)lv));
        }
    }
}

