/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDFSShell;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;

public class TestSetrepIncreasing
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setrep(int fromREP, int toREP, boolean simulatedStorage) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        conf.set("dfs.replication", "" + fromREP);
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.namenode.replication.pending.timeout-sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(10).build();
        FileSystem fs = cluster.getFileSystem();
        TestSetrepIncreasing.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        try {
            Path root = TestDFSShell.mkdir(fs, new Path("/test/setrep" + fromREP + "-" + toREP));
            Path f = TestDFSShell.writeFile(fs, new Path(root, "foo"));
            String[] args = new String[]{"-setrep", "-w", "" + toREP, "" + f};
            FsShell shell = new FsShell();
            shell.setConf((Configuration)conf);
            try {
                TestSetrepIncreasing.assertEquals((int)0, (int)shell.run(args));
            }
            catch (Exception e) {
                TestSetrepIncreasing.assertTrue((String)("-setrep " + e), (boolean)false);
            }
            fs = cluster.getFileSystem();
            FileStatus file = fs.getFileStatus(f);
            long len = file.getLen();
            for (BlockLocation locations : fs.getFileBlockLocations(file, 0L, len)) {
                TestSetrepIncreasing.assertTrue((locations.getHosts().length == toREP ? 1 : 0) != 0);
            }
            TestDFSShell.show("done setrep waiting: " + root);
        }
        finally {
            try {
                fs.close();
            }
            catch (Exception e) {}
            cluster.shutdown();
        }
    }

    public void testSetrepIncreasing() throws IOException {
        TestSetrepIncreasing.setrep(3, 7, false);
    }

    public void testSetrepIncreasingSimulatedStorage() throws IOException {
        TestSetrepIncreasing.setrep(3, 7, true);
    }
}

