/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;

public class TestSetTimes
extends TestCase {
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int fileSize = 16384;
    static final int numDatanodes = 1;
    static final SimpleDateFormat dateForm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    Random myrand = new Random();
    Path hostsFile;
    Path excludeFile;

    private FSDataOutputStream writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        byte[] buffer = new byte[16384];
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        return stm;
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestSetTimes.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        TestSetTimes.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    private void printDatanodeReport(DatanodeInfo[] info) {
        System.out.println("-------------------------------------------------");
        for (int i = 0; i < info.length; ++i) {
            System.out.println(info[i].getDatanodeReport());
            System.out.println();
        }
    }

    public void testTimes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        int nnport = cluster.getNameNodePort();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        TestSetTimes.assertEquals((String)"Number of Datanodes ", (int)1, (int)info.length);
        FileSystem fileSys = cluster.getFileSystem();
        int replicas = 1;
        TestSetTimes.assertTrue((boolean)(fileSys instanceof DistributedFileSystem));
        try {
            System.out.println("Creating testdir1 and testdir1/test1.dat.");
            Path dir1 = new Path("testdir1");
            Path file1 = new Path(dir1, "test1.dat");
            FSDataOutputStream stm = this.writeFile(fileSys, file1, replicas);
            FileStatus stat = fileSys.getFileStatus(file1);
            long atimeBeforeClose = stat.getAccessTime();
            String adate = dateForm.format(new Date(atimeBeforeClose));
            System.out.println("atime on " + file1 + " before close is " + adate + " (" + atimeBeforeClose + ")");
            TestSetTimes.assertTrue((atimeBeforeClose != 0L ? 1 : 0) != 0);
            stm.close();
            stat = fileSys.getFileStatus(file1);
            long atime1 = stat.getAccessTime();
            long mtime1 = stat.getModificationTime();
            adate = dateForm.format(new Date(atime1));
            String mdate = dateForm.format(new Date(mtime1));
            System.out.println("atime on " + file1 + " is " + adate + " (" + atime1 + ")");
            System.out.println("mtime on " + file1 + " is " + mdate + " (" + mtime1 + ")");
            TestSetTimes.assertTrue((atime1 != 0L ? 1 : 0) != 0);
            stat = fileSys.getFileStatus(dir1);
            long mdir1 = stat.getAccessTime();
            TestSetTimes.assertTrue((mdir1 == 0L ? 1 : 0) != 0);
            long atime2 = atime1 - 86400000L;
            fileSys.setTimes(file1, -1L, atime2);
            stat = fileSys.getFileStatus(file1);
            long atime3 = stat.getAccessTime();
            String adate3 = dateForm.format(new Date(atime3));
            System.out.println("new atime on " + file1 + " is " + adate3 + " (" + atime3 + ")");
            TestSetTimes.assertTrue((atime2 == atime3 ? 1 : 0) != 0);
            TestSetTimes.assertTrue((mtime1 == stat.getModificationTime() ? 1 : 0) != 0);
            long mtime2 = mtime1 - 3600000L;
            fileSys.setTimes(file1, mtime2, -1L);
            stat = fileSys.getFileStatus(file1);
            long mtime3 = stat.getModificationTime();
            String mdate3 = dateForm.format(new Date(mtime3));
            System.out.println("new mtime on " + file1 + " is " + mdate3 + " (" + mtime3 + ")");
            TestSetTimes.assertTrue((atime2 == stat.getAccessTime() ? 1 : 0) != 0);
            TestSetTimes.assertTrue((mtime2 == mtime3 ? 1 : 0) != 0);
            long mtime4 = System.currentTimeMillis() - 3600000L;
            long atime4 = System.currentTimeMillis();
            fileSys.setTimes(dir1, mtime4, atime4);
            stat = fileSys.getFileStatus(dir1);
            TestSetTimes.assertTrue((String)"Not matching the modification times", (mtime4 == stat.getModificationTime() ? 1 : 0) != 0);
            TestSetTimes.assertTrue((String)"Not matching the access times", (atime4 == stat.getAccessTime() ? 1 : 0) != 0);
            Path nonExistingDir = new Path(dir1, "/nonExistingDir/");
            try {
                fileSys.setTimes(nonExistingDir, mtime4, atime4);
                TestSetTimes.fail((String)"Expecting FileNotFoundException");
            }
            catch (FileNotFoundException e) {
                TestSetTimes.assertTrue((boolean)e.getMessage().contains("File/Directory " + nonExistingDir.toString() + " does not exist."));
            }
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            System.out.println("Verifying times after cluster restart");
            stat = fileSys.getFileStatus(file1);
            TestSetTimes.assertTrue((atime2 == stat.getAccessTime() ? 1 : 0) != 0);
            TestSetTimes.assertTrue((mtime3 == stat.getModificationTime() ? 1 : 0) != 0);
            this.cleanupFile(fileSys, file1);
            this.cleanupFile(fileSys, dir1);
        }
        catch (IOException e) {
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            this.printDatanodeReport(info);
            throw e;
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    public void testTimesAtClose() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        int replicas = 1;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.datanode.handler.count", 50);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        DatanodeInfo[] info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE);
        TestSetTimes.assertEquals((String)"Number of Datanodes ", (int)1, (int)info.length);
        FileSystem fileSys = cluster.getFileSystem();
        TestSetTimes.assertTrue((boolean)(fileSys instanceof DistributedFileSystem));
        try {
            Path file1 = new Path("/simple.dat");
            FSDataOutputStream stm = this.writeFile(fileSys, file1, replicas);
            System.out.println("Created and wrote file simple.dat");
            FileStatus statBeforeClose = fileSys.getFileStatus(file1);
            long mtimeBeforeClose = statBeforeClose.getModificationTime();
            String mdateBeforeClose = dateForm.format(new Date(mtimeBeforeClose));
            System.out.println("mtime on " + file1 + " before close is " + mdateBeforeClose + " (" + mtimeBeforeClose + ")");
            TestSetTimes.assertTrue((mtimeBeforeClose != 0L ? 1 : 0) != 0);
            stm.close();
            System.out.println("Closed file.");
            FileStatus statAfterClose = fileSys.getFileStatus(file1);
            long mtimeAfterClose = statAfterClose.getModificationTime();
            String mdateAfterClose = dateForm.format(new Date(mtimeAfterClose));
            System.out.println("mtime on " + file1 + " after close is " + mdateAfterClose + " (" + mtimeAfterClose + ")");
            TestSetTimes.assertTrue((mtimeAfterClose != 0L ? 1 : 0) != 0);
            TestSetTimes.assertTrue((mtimeBeforeClose != mtimeAfterClose ? 1 : 0) != 0);
            this.cleanupFile(fileSys, file1);
        }
        catch (IOException e) {
            info = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            this.printDatanodeReport(info);
            throw e;
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestSetTimes().testTimes();
    }
}

