/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;

public class TestPread
extends TestCase {
    static final long seed = 3735928559L;
    static final int blockSize = 4096;
    boolean simulatedStorage = false;

    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, 4096, (short)1, 4096L);
        stm.close();
        FSDataInputStream in = fileSys.open(name);
        byte[] buffer = new byte[49152];
        in.readFully(0L, buffer, 0, 0);
        IOException res = null;
        try {
            in.readFully(0L, buffer, 0, 1);
        }
        catch (IOException e) {
            res = e;
        }
        TestPread.assertTrue((String)"Error reading beyond file boundary.", (res != null ? 1 : 0) != 0);
        in.close();
        if (!fileSys.delete(name, true)) {
            TestPread.assertTrue((String)"Cannot delete file", (boolean)false);
        }
        stm = fileSys.create(name, true, 4096, (short)1, 4096L);
        Random rand = new Random(3735928559L);
        rand.nextBytes(buffer);
        stm.write(buffer);
        stm.close();
    }

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            TestPread.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (byte)actual[idx], (byte)expected[from + idx]);
            actual[idx] = 0;
        }
    }

    private void doPread(FSDataInputStream stm, long position, byte[] buffer, int offset, int length) throws IOException {
        int nbytes;
        for (int nread = 0; nread < length; nread += nbytes) {
            nbytes = stm.read(position + (long)nread, buffer, offset + nread, length - nread);
            TestPread.assertTrue((String)"Error in pread", (nbytes > 0 ? 1 : 0) != 0);
        }
    }

    private void pReadFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] expected = new byte[49152];
        if (this.simulatedStorage) {
            for (int i = 0; i < expected.length; ++i) {
                expected[i] = 9;
            }
        } else {
            Random rand = new Random(3735928559L);
            rand.nextBytes(expected);
        }
        byte[] actual = new byte[4096];
        stm.readFully(actual);
        this.checkAndEraseData(actual, 0, expected, "Read Sanity Test");
        actual = new byte[8192];
        this.doPread(stm, 0L, actual, 0, 8192);
        this.checkAndEraseData(actual, 0, expected, "Pread Test 1");
        actual = new byte[4096];
        stm.readFully(actual);
        this.checkAndEraseData(actual, 4096, expected, "Pread Test 2");
        stm.readFully(2048L, actual, 0, 4096);
        this.checkAndEraseData(actual, 2048, expected, "Pread Test 3");
        actual = new byte[8192];
        stm.readFully(2048L, actual);
        this.checkAndEraseData(actual, 2048, expected, "Pread Test 4");
        actual = new byte[8192];
        stm.readFully(38912L, actual);
        this.checkAndEraseData(actual, 38912, expected, "Pread Test 5");
        actual = new byte[4096];
        stm.readFully(actual);
        this.checkAndEraseData(actual, 8192, expected, "Pread Test 6");
        stm.close();
        stm = fileSys.open(name);
        stm.readFully(1L, actual, 0, 4096);
        stm.readFully(16384L, actual, 0, 4096);
        stm.readFully(28672L, actual, 0, 4096);
        actual = new byte[12288];
        stm.readFully(0L, actual, 0, 12288);
        this.checkAndEraseData(actual, 0, expected, "Pread Test 7");
        actual = new byte[32768];
        stm.readFully(12288L, actual, 0, 32768);
        this.checkAndEraseData(actual, 12288, expected, "Pread Test 8");
        stm.readFully(47104L, actual, 0, 2048);
        IOException res = null;
        try {
            stm.readFully(47104L, actual, 0, 4096);
        }
        catch (IOException e) {
            res = e;
        }
        TestPread.assertTrue((String)"Error reading beyond file boundary.", (res != null ? 1 : 0) != 0);
        stm.close();
    }

    private void datanodeRestartTest(MiniDFSCluster cluster, FileSystem fileSys, Path name) throws IOException {
        if (this.simulatedStorage) {
            return;
        }
        int numBlocks = 1;
        TestPread.assertTrue((numBlocks <= 3 ? 1 : 0) != 0);
        byte[] expected = new byte[numBlocks * 4096];
        Random rand = new Random(3735928559L);
        rand.nextBytes(expected);
        byte[] actual = new byte[numBlocks * 4096];
        FSDataInputStream stm = fileSys.open(name);
        stm.readFully(0L, actual);
        this.checkAndEraseData(actual, 0, expected, "Pread Datanode Restart Setup");
        TestPread.assertTrue((boolean)cluster.restartDataNodes());
        cluster.waitActive();
        stm.readFully(0L, actual);
        this.checkAndEraseData(actual, 0, expected, "Pread Datanode Restart Test");
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestPread.assertTrue((boolean)fileSys.exists(name));
        TestPread.assertTrue((boolean)fileSys.delete(name, true));
        TestPread.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    public void testPreadDFS() throws IOException {
        this.dfsPreadTest(false);
        this.dfsPreadTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dfsPreadTest(boolean disableTransferTo) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 4096L);
        conf.setLong("dfs.client.read.prefetch.size", 4096L);
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        if (disableTransferTo) {
            conf.setBoolean("dfs.datanode.transferTo.allowed", false);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            Path file1 = new Path("preadtest.dat");
            this.writeFile(fileSys, file1);
            this.pReadFile(fileSys, file1);
            this.datanodeRestartTest(cluster, fileSys, file1);
            this.cleanupFile(fileSys, file1);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    public void testPreadDFSSimulated() throws IOException {
        this.simulatedStorage = true;
        this.testPreadDFS();
        this.simulatedStorage = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreadLocalFS() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);
        try {
            Path file1 = new Path("build/test/data", "preadtest.dat");
            this.writeFile((FileSystem)fileSys, file1);
            this.pReadFile((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, file1);
        }
        finally {
            fileSys.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestPread().testPreadDFS();
    }
}

