/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMiniDFSCluster {
    private static final String CLUSTER_1 = "cluster1";
    private static final String CLUSTER_2 = "cluster2";
    private static final String CLUSTER_3 = "cluster3";
    protected String testDataPath;
    protected File testDataDir;

    @Before
    public void setUp() {
        this.testDataPath = System.getProperty("test.build.data");
        this.testDataDir = new File(new File(this.testDataPath).getParentFile(), "miniclusters");
    }

    @After
    public void tearDown() {
        System.setProperty("test.build.data", this.testDataPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithoutSystemProperties() throws Throwable {
        System.clearProperty("test.build.data");
        HdfsConfiguration conf = new HdfsConfiguration();
        File testDataCluster1 = new File(this.testDataPath, CLUSTER_1);
        String c1Path = testDataCluster1.getAbsolutePath();
        conf.set("hdfs.minidfs.basedir", c1Path);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            Assert.assertEquals((String)(c1Path + "/data"), (String)cluster.getDataDirectory());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDualClusters() throws Throwable {
        File testDataCluster2 = new File(this.testDataPath, CLUSTER_2);
        File testDataCluster3 = new File(this.testDataPath, CLUSTER_3);
        HdfsConfiguration conf = new HdfsConfiguration();
        String c2Path = testDataCluster2.getAbsolutePath();
        conf.set("hdfs.minidfs.basedir", c2Path);
        MiniDFSCluster cluster2 = new MiniDFSCluster.Builder((Configuration)conf).build();
        MiniDFSCluster cluster3 = null;
        try {
            String dataDir2 = cluster2.getDataDirectory();
            Assert.assertEquals((String)(c2Path + "/data"), (String)dataDir2);
            conf.set("hdfs.minidfs.basedir", testDataCluster3.getAbsolutePath());
            MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder((Configuration)conf);
            cluster3 = builder.build();
            String dataDir3 = cluster3.getDataDirectory();
            Assert.assertTrue((String)("Clusters are bound to the same directory: " + dataDir2), (!dataDir2.equals(dataDir3) ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            MiniDFSCluster.shutdownCluster(cluster3);
            MiniDFSCluster.shutdownCluster(cluster2);
            throw throwable;
        }
        MiniDFSCluster.shutdownCluster(cluster3);
        MiniDFSCluster.shutdownCluster(cluster2);
    }
}

