/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestLocalDFS
extends TestCase {
    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name);
        stm.writeBytes("oom");
        stm.close();
    }

    private void readFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] buffer = new byte[4];
        int bytesRead = stm.read(buffer, 0, 4);
        TestLocalDFS.assertEquals((String)"oom", (String)new String(buffer, 0, bytesRead));
        stm.close();
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        TestLocalDFS.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        TestLocalDFS.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    static String getUserName(FileSystem fs) {
        if (fs instanceof DistributedFileSystem) {
            return ((DistributedFileSystem)fs).dfs.ugi.getShortUserName();
        }
        return System.getProperty("user.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkingDirectory() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            Path orig_path = fileSys.getWorkingDirectory();
            TestLocalDFS.assertTrue((boolean)orig_path.isAbsolute());
            Path file1 = new Path("somewhat/random.txt");
            this.writeFile(fileSys, file1);
            TestLocalDFS.assertTrue((boolean)fileSys.exists(new Path(orig_path, file1.toString())));
            fileSys.delete(file1, true);
            Path subdir1 = new Path("/somewhere");
            fileSys.setWorkingDirectory(subdir1);
            this.writeFile(fileSys, file1);
            this.cleanupFile(fileSys, new Path(subdir1, file1.toString()));
            Path subdir2 = new Path("else");
            fileSys.setWorkingDirectory(subdir2);
            this.writeFile(fileSys, file1);
            this.readFile(fileSys, file1);
            this.cleanupFile(fileSys, new Path(new Path(subdir1, subdir2.toString()), file1.toString()));
            Path home = fileSys.makeQualified(new Path("/user/" + TestLocalDFS.getUserName(fileSys)));
            Path fsHome = fileSys.getHomeDirectory();
            TestLocalDFS.assertEquals((Object)home, (Object)fsHome);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }
}

