/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.EnumSet;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;

public class TestFileCreation
extends TestCase {
    static final String DIR = "/" + TestFileCreation.class.getSimpleName() + "/";
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    static final int numBlocks = 2;
    static final int fileSize = 16385;
    boolean simulatedStorage;
    private static final String[] NON_CANONICAL_PATHS = new String[]{"//foo", "///foo2", "//dir//file", "////test2/file", "/dir/./file2", "/dir/../file3"};

    public TestFileCreation() {
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        this.simulatedStorage = false;
    }

    public static FSDataOutputStream createFile(FileSystem fileSys, Path name, int repl) throws IOException {
        System.out.println("createFile: Created " + name + " with " + repl + " replica.");
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L);
        return stm;
    }

    static void writeFile(FSDataOutputStream stm) throws IOException {
        TestFileCreation.writeFile(stm, 16385);
    }

    public static void writeFile(FSDataOutputStream stm, int size) throws IOException {
        byte[] buffer = AppendTestUtil.randomBytes(3735928559L, size);
        stm.write(buffer, 0, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerDefaults() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 0x4000000L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        conf.setInt("dfs.client-write-packet-size", 65536);
        conf.setInt("dfs.replication", 4);
        conf.setInt("io.file.buffer.size", 4096);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        try {
            FsServerDefaults serverDefaults = fs.getServerDefaults();
            TestFileCreation.assertEquals((long)0x4000000L, (long)serverDefaults.getBlockSize());
            TestFileCreation.assertEquals((int)512, (int)serverDefaults.getBytesPerChecksum());
            TestFileCreation.assertEquals((int)65536, (int)serverDefaults.getWritePacketSize());
            TestFileCreation.assertEquals((int)4, (int)serverDefaults.getReplication());
            TestFileCreation.assertEquals((int)4096, (int)serverDefaults.getFileBufferSize());
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCreation() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = cluster.getFileSystem();
        try {
            block7: {
                Path path = new Path("/");
                System.out.println("Path : \"" + path.toString() + "\"");
                System.out.println(fs.getFileStatus(path).isDirectory());
                TestFileCreation.assertTrue((String)"/ should be a directory", (boolean)fs.getFileStatus(path).isDirectory());
                Path dir1 = new Path("/test_dir");
                fs.mkdirs(dir1);
                System.out.println("createFile: Creating " + dir1.getName() + " for overwrite of existing directory.");
                try {
                    fs.create(dir1, true);
                    fs.close();
                    TestFileCreation.assertTrue((String)"Did not prevent directory from being overwritten.", (boolean)false);
                }
                catch (IOException ie) {
                    if (ie.getMessage().contains("already exists as a directory.")) break block7;
                    throw ie;
                }
            }
            Path file1 = new Path("filestatus.dat");
            Path parent = file1.getParent();
            fs.mkdirs(parent);
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            dfs.setQuota(file1.getParent(), 100L, 40960L);
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            TestFileCreation.assertTrue((String)(file1 + " should be a file"), (boolean)fs.getFileStatus(file1).isFile());
            System.out.println("Path : \"" + file1 + "\"");
            TestFileCreation.writeFile(stm);
            stm.close();
            long len = fs.getFileStatus(file1).getLen();
            TestFileCreation.assertTrue((String)(file1 + " should be of size " + 16385 + " but found to be of size " + len), (len == 16385L ? 1 : 0) != 0);
            long diskSpace = dfs.getContentSummary(file1.getParent()).getLength();
            TestFileCreation.assertEquals((String)(file1 + " should take " + 16385 + " bytes disk space " + "but found to take " + diskSpace + " bytes"), (long)16385L, (long)diskSpace);
            if (this.simulatedStorage) {
                DataNode dn = cluster.getDataNodes().get(0);
                TestFileCreation.assertEquals((long)16385L, (long)dn.getFSDataset().getDfsUsed());
                TestFileCreation.assertEquals((long)0x1FFFFFFBFFFL, (long)dn.getFSDataset().getRemaining());
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteOnExit() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = cluster.getFileSystem();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        try {
            Path file1 = new Path("filestatus.dat");
            Path file2 = new Path("filestatus2.dat");
            Path file3 = new Path("filestatus3.dat");
            FSDataOutputStream stm1 = TestFileCreation.createFile(fs, file1, 1);
            FSDataOutputStream stm2 = TestFileCreation.createFile(fs, file2, 1);
            FSDataOutputStream stm3 = TestFileCreation.createFile((FileSystem)localfs, file3, 1);
            System.out.println("DeleteOnExit: Created files.");
            TestFileCreation.writeFile(stm1);
            TestFileCreation.writeFile(stm3);
            stm1.close();
            stm2.close();
            stm3.close();
            fs.deleteOnExit(file1);
            fs.deleteOnExit(file2);
            localfs.deleteOnExit(file3);
            fs.close();
            localfs.close();
            fs = null;
            localfs = null;
            fs = cluster.getFileSystem();
            localfs = FileSystem.getLocal((Configuration)conf);
            TestFileCreation.assertTrue((String)(file1 + " still exists inspite of deletOnExit set."), (!fs.exists(file1) ? 1 : 0) != 0);
            TestFileCreation.assertTrue((String)(file2 + " still exists inspite of deletOnExit set."), (!fs.exists(file2) ? 1 : 0) != 0);
            TestFileCreation.assertTrue((String)(file3 + " still exists inspite of deletOnExit set."), (!localfs.exists(file3) ? 1 : 0) != 0);
            System.out.println("DeleteOnExit successful.");
        }
        finally {
            IOUtils.closeStream((Closeable)fs);
            IOUtils.closeStream((Closeable)localfs);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCreationError1() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = cluster.getFileSystem();
        cluster.waitActive();
        InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
        DFSClient client = new DFSClient(addr, (Configuration)conf);
        try {
            DatanodeInfo[] info;
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            TestFileCreation.assertTrue((String)(file1 + " should be a file"), (boolean)fs.getFileStatus(file1).isFile());
            System.out.println("Path : \"" + file1 + "\"");
            cluster.shutdownDataNodes();
            while ((info = client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE)).length != 0) {
                System.out.println("testFileCreationError1: waiting for datanode  to die.");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            byte[] buffer = AppendTestUtil.randomBytes(3735928559L, 1);
            try {
                stm.write(buffer);
                stm.close();
            }
            catch (Exception e) {
                System.out.println("Encountered expected exception");
            }
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            TestFileCreation.assertTrue((String)"Error blocks were not cleaned up", (locations.locatedBlockCount() == 0 ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCreationError2() throws IOException {
        long leasePeriod = 1000L;
        System.out.println("testFileCreationError2 start");
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            DFSClient client = dfs.dfs;
            Path file1 = new Path("/filestatus.dat");
            TestFileCreation.createFile((FileSystem)dfs, file1, 1);
            System.out.println("testFileCreationError2: Created file filestatus.dat with one replicas.");
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("testFileCreationError2: The file has " + locations.locatedBlockCount() + " blocks.");
            LocatedBlock location = client.getNamenode().addBlock(file1.toString(), client.clientName, null, null);
            System.out.println("testFileCreationError2: Added block " + location.getBlock());
            locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            int count = locations.locatedBlockCount();
            System.out.println("testFileCreationError2: The file now has " + count + " blocks.");
            cluster.setLeasePeriod(leasePeriod, leasePeriod);
            try {
                Thread.sleep(5L * leasePeriod);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("testFileCreationError2: locations = " + locations.locatedBlockCount());
            TestFileCreation.assertEquals((int)0, (int)locations.locatedBlockCount());
            System.out.println("testFileCreationError2 successful");
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCreationError3() throws IOException {
        System.out.println("testFileCreationError3 start");
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            DFSClient client = dfs.dfs;
            Path f = new Path("/foo.txt");
            TestFileCreation.createFile((FileSystem)dfs, f, 3);
            try {
                cluster.getNameNodeRpc().addBlock(f.toString(), client.clientName, null, null);
                TestFileCreation.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD!", (Throwable)ioe);
            }
            System.out.println("testFileCreationError3 successful");
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xxxtestFileCreationNamenodeRestart() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        int MAX_IDLE_TIME = 2000;
        conf.setInt("ipc.client.connection.maxidletime", 2000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = null;
        try {
            cluster.waitActive();
            fs = cluster.getFileSystem();
            int nnport = cluster.getNameNodePort();
            Path file1 = new Path("/filestatus.dat");
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file1);
            int actualRepl = ((DFSOutputStream)stm.getWrappedStream()).getNumCurrentReplicas();
            TestFileCreation.assertTrue((String)(file1 + " should be replicated to 1 datanodes."), (actualRepl == 1 ? 1 : 0) != 0);
            TestFileCreation.writeFile(stm, 16384);
            stm.hflush();
            actualRepl = ((DFSOutputStream)stm.getWrappedStream()).getNumCurrentReplicas();
            TestFileCreation.assertTrue((String)(file1 + " should still be replicated to 1 datanodes."), (actualRepl == 1 ? 1 : 0) != 0);
            Path fileRenamed = new Path("/filestatusRenamed.dat");
            fs.rename(file1, fileRenamed);
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file1 + " to " + fileRenamed);
            file1 = fileRenamed;
            Path file2 = new Path("/filestatus2.dat");
            FSDataOutputStream stm2 = TestFileCreation.createFile(fs, file2, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file2);
            Path file3 = new Path("/user/home/fullpath.dat");
            FSDataOutputStream stm3 = TestFileCreation.createFile(fs, file3, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file3);
            Path file4 = new Path("/user/home/fullpath4.dat");
            FSDataOutputStream stm4 = TestFileCreation.createFile(fs, file4, 1);
            System.out.println("testFileCreationNamenodeRestart: Created file " + file4);
            fs.mkdirs(new Path("/bin"));
            fs.rename(new Path("/user/home"), new Path("/bin"));
            Path file3new = new Path("/bin/home/fullpath.dat");
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file3 + " to " + file3new);
            Path file4new = new Path("/bin/home/fullpath4.dat");
            System.out.println("testFileCreationNamenodeRestart: Renamed file " + file4 + " to " + file4new);
            cluster.shutdown();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).build();
            cluster.waitActive();
            cluster.shutdown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            cluster = new MiniDFSCluster.Builder((Configuration)conf).nameNodePort(nnport).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            DFSOutputStream dfstream = (DFSOutputStream)stm.getWrappedStream();
            dfstream.setTestFilename(file1.toString());
            dfstream = (DFSOutputStream)stm3.getWrappedStream();
            dfstream.setTestFilename(file3new.toString());
            dfstream = (DFSOutputStream)stm4.getWrappedStream();
            dfstream.setTestFilename(file4new.toString());
            byte[] buffer = AppendTestUtil.randomBytes(3735928559L, 1);
            stm.write(buffer);
            stm.close();
            stm2.write(buffer);
            stm2.close();
            stm3.close();
            stm4.close();
            DFSClient client = ((DistributedFileSystem)fs).dfs;
            LocatedBlocks locations = client.getNamenode().getBlockLocations(file1.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            TestFileCreation.assertTrue((String)("Error blocks were not cleaned up for file " + file1), (locations.locatedBlockCount() == 3 ? 1 : 0) != 0);
            locations = client.getNamenode().getBlockLocations(file2.toString(), 0L, Long.MAX_VALUE);
            System.out.println("locations = " + locations.locatedBlockCount());
            TestFileCreation.assertTrue((String)("Error blocks were not cleaned up for file " + file2), (locations.locatedBlockCount() == 1 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(fs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)fs);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDFSClientDeath() throws IOException, InterruptedException {
        HdfsConfiguration conf = new HdfsConfiguration();
        System.out.println("Testing adbornal client death.");
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = cluster.getFileSystem();
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsclient = dfs.dfs;
        try {
            Path file1 = new Path("/clienttest.dat");
            FSDataOutputStream stm = TestFileCreation.createFile(fs, file1, 1);
            System.out.println("Created file clienttest.dat");
            TestFileCreation.writeFile(stm);
            dfsclient.close();
            TestFileCreation.assertTrue((String)(file1 + " does not exist."), (boolean)AppendTestUtil.createHdfsWithDifferentUsername((Configuration)conf).exists(file1));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCreationNonRecursive() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = cluster.getFileSystem();
        Path path = new Path("/" + System.currentTimeMillis() + "-testFileCreationNonRecursive");
        FSDataOutputStream out = null;
        try {
            IOException expectedException = null;
            String nonExistDir = "/non-exist-" + System.currentTimeMillis();
            fs.delete(new Path(nonExistDir), true);
            EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE);
            out = TestFileCreation.createNonRecursive(fs, path, 1, createFlag);
            out.close();
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, new Path(path, "Create"), 1, createFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            TestFileCreation.assertTrue((String)"Create a file when parent directory exists as a file should throw ParentNotDirectoryException ", (expectedException != null && expectedException instanceof ParentNotDirectoryException ? 1 : 0) != 0);
            fs.delete(path, true);
            Path path2 = new Path(nonExistDir + "/testCreateNonRecursive");
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, path2, 1, createFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            TestFileCreation.assertTrue((String)"Create a file in a non-exist dir using createNonRecursive() should throw FileNotFoundException ", (expectedException != null && expectedException instanceof FileNotFoundException ? 1 : 0) != 0);
            EnumSet<CreateFlag> overwriteFlag = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
            out = TestFileCreation.createNonRecursive(fs, path, 1, overwriteFlag);
            out.close();
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, new Path(path, "Overwrite"), 1, overwriteFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            TestFileCreation.assertTrue((String)"Overwrite a file when parent directory exists as a file should throw ParentNotDirectoryException ", (expectedException != null && expectedException instanceof ParentNotDirectoryException ? 1 : 0) != 0);
            fs.delete(path, true);
            Path path3 = new Path(nonExistDir + "/testOverwriteNonRecursive");
            expectedException = null;
            try {
                TestFileCreation.createNonRecursive(fs, path3, 1, overwriteFlag);
            }
            catch (IOException e) {
                expectedException = e;
            }
            TestFileCreation.assertTrue((String)"Overwrite a file in a non-exist dir using createNonRecursive() should throw FileNotFoundException ", (expectedException != null && expectedException instanceof FileNotFoundException ? 1 : 0) != 0);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    static FSDataOutputStream createNonRecursive(FileSystem fs, Path name, int repl, EnumSet<CreateFlag> flag) throws IOException {
        System.out.println("createNonRecursive: Created " + name + " with " + repl + " replica.");
        FSDataOutputStream stm = ((DistributedFileSystem)fs).createNonRecursive(name, FsPermission.getDefault(), flag, fs.getConf().getInt("io.file.buffer.size", 4096), (short)repl, 8192L, null);
        return stm;
    }

    public void testFileCreationSimulated() throws IOException {
        this.simulatedStorage = true;
        this.testFileCreation();
        this.simulatedStorage = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentFileCreation() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            int i;
            FileSystem fs = cluster.getFileSystem();
            Path[] p = new Path[]{new Path("/foo"), new Path("/bar")};
            FSDataOutputStream[] out = new FSDataOutputStream[]{fs.create(p[0]), fs.create(p[1])};
            for (i = 0; i < 100; ++i) {
                out[0].write(i);
                out[1].write(i);
            }
            out[0].close();
            while (i < 200) {
                out[1].write(i);
                ++i;
            }
            out[1].close();
            FSDataInputStream[] in = new FSDataInputStream[]{fs.open(p[0]), fs.open(p[1])};
            for (i = 0; i < 100; ++i) {
                TestFileCreation.assertEquals((int)i, (int)in[0].read());
            }
            for (i = 0; i < 200; ++i) {
                TestFileCreation.assertEquals((int)i, (int)in[1].read());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCreationSyncOnClose() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.datanode.synconclose", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            int i;
            FileSystem fs = cluster.getFileSystem();
            Path[] p = new Path[]{new Path("/foo"), new Path("/bar")};
            FSDataOutputStream[] out = new FSDataOutputStream[]{fs.create(p[0]), fs.create(p[1])};
            for (i = 0; i < 100; ++i) {
                out[0].write(i);
                out[1].write(i);
            }
            out[0].close();
            while (i < 200) {
                out[1].write(i);
                ++i;
            }
            out[1].close();
            FSDataInputStream[] in = new FSDataInputStream[]{fs.open(p[0]), fs.open(p[1])};
            for (i = 0; i < 100; ++i) {
                TestFileCreation.assertEquals((int)i, (int)in[0].read());
            }
            for (i = 0; i < 200; ++i) {
                TestFileCreation.assertEquals((int)i, (int)in[1].read());
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeaseExpireHardLimit() throws Exception {
        System.out.println("testLeaseExpireHardLimit start");
        long leasePeriod = 1000L;
        int DATANODE_NUM = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            String f = DIR + "foo";
            Path fpath = new Path(f);
            FSDataOutputStream out = TestFileCreation.createFile((FileSystem)dfs, fpath, 3);
            out.write("something".getBytes());
            out.hflush();
            int actualRepl = ((DFSOutputStream)out.getWrappedStream()).getNumCurrentReplicas();
            TestFileCreation.assertTrue((String)(f + " should be replicated to " + 3 + " datanodes."), (actualRepl == 3 ? 1 : 0) != 0);
            cluster.setLeasePeriod(1000L, 1000L);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            LocatedBlocks locations = dfs.dfs.getNamenode().getBlockLocations(f, 0L, Long.MAX_VALUE);
            TestFileCreation.assertEquals((int)1, (int)locations.locatedBlockCount());
            LocatedBlock locatedblock = (LocatedBlock)locations.getLocatedBlocks().get(0);
            int successcount = 0;
            for (DatanodeInfo datanodeinfo : locatedblock.getLocations()) {
                DataNode datanode = cluster.getDataNode(datanodeinfo.ipcPort);
                ExtendedBlock blk = locatedblock.getBlock();
                Block b = datanode.data.getStoredBlock(blk.getBlockPoolId(), blk.getBlockId());
                File blockfile = DataNodeTestUtils.getFile(datanode, blk.getBlockPoolId(), b.getBlockId());
                System.out.println("blockfile=" + blockfile);
                if (blockfile == null) continue;
                BufferedReader in = new BufferedReader(new FileReader(blockfile));
                TestFileCreation.assertEquals((String)"something", (String)in.readLine());
                in.close();
                ++successcount;
            }
            System.out.println("successcount=" + successcount);
            TestFileCreation.assertTrue((successcount > 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(dfs);
            cluster.shutdown();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)dfs);
        cluster.shutdown();
        System.out.println("testLeaseExpireHardLimit successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsClose() throws Exception {
        System.out.println("test file system close start");
        int DATANODE_NUM = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            String f = DIR + "foofs";
            Path fpath = new Path(f);
            FSDataOutputStream out = TestFileCreation.createFile((FileSystem)dfs, fpath, 3);
            out.write("something".getBytes());
            dfs.close();
        }
        finally {
            System.out.println("testFsClose successful");
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFsCloseAfterClusterShutdown() throws IOException {
        System.out.println("test testFsCloseAfterClusterShutdown start");
        int DATANODE_NUM = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.replication.min", 3);
        conf.setBoolean("ipc.client.ping", false);
        conf.setInt("ipc.ping.interval", 10000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem dfs = null;
        try {
            cluster.waitActive();
            dfs = (DistributedFileSystem)cluster.getFileSystem();
            String f = DIR + "testFsCloseAfterClusterShutdown";
            Path fpath = new Path(f);
            FSDataOutputStream out = TestFileCreation.createFile((FileSystem)dfs, fpath, 3);
            out.write("something_test".getBytes());
            out.hflush();
            cluster.stopDataNode(2);
            boolean hasException = false;
            try {
                out.close();
                System.out.println("testFsCloseAfterClusterShutdown: Error here");
            }
            catch (IOException e) {
                hasException = true;
            }
            TestFileCreation.assertTrue((String)"Failed to close file after cluster shutdown", (boolean)hasException);
        }
        finally {
            System.out.println("testFsCloseAfterClusterShutdown successful");
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testCreateNonCanonicalPathAndRestartRpc() throws Exception {
        this.doCreateTest(CreationMethod.DIRECT_NN_RPC);
    }

    public void testCreateNonCanonicalPathAndRestartFromString() throws Exception {
        this.doCreateTest(CreationMethod.PATH_FROM_STRING);
    }

    public void testCreateNonCanonicalPathAndRestartFromUri() throws Exception {
        this.doCreateTest(CreationMethod.PATH_FROM_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateTest(CreationMethod method) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            FileSystem fs = cluster.getFileSystem();
            NamenodeProtocols nnrpc = cluster.getNameNodeRpc();
            block9: for (String pathStr : NON_CANONICAL_PATHS) {
                System.out.println("Creating " + pathStr + " by " + (Object)((Object)method));
                switch (method) {
                    case DIRECT_NN_RPC: {
                        try {
                            nnrpc.create(pathStr, new FsPermission(493), "client", new EnumSetWritable(EnumSet.of(CreateFlag.CREATE)), true, (short)1, 0x8000000L);
                            TestFileCreation.fail((String)("Should have thrown exception when creating '" + pathStr + "'" + " by " + (Object)((Object)method)));
                        }
                        catch (InvalidPathException ipe) {}
                        continue block9;
                    }
                    case PATH_FROM_URI: 
                    case PATH_FROM_STRING: {
                        Path p = method == CreationMethod.PATH_FROM_URI ? new Path(new URI(fs.getUri() + pathStr)) : new Path(fs.getUri() + pathStr);
                        FSDataOutputStream stm = fs.create(p);
                        IOUtils.closeStream((Closeable)stm);
                        continue block9;
                    }
                    default: {
                        throw new AssertionError((Object)("bad method: " + (Object)((Object)method)));
                    }
                }
            }
            cluster.restartNameNode();
        }
        finally {
            cluster.shutdown();
        }
    }

    private static enum CreationMethod {
        DIRECT_NN_RPC,
        PATH_FROM_URI,
        PATH_FROM_STRING;

    }
}

