/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.log4j.Level;

public class TestFileCorruption
extends TestCase {
    static Log LOG = (Log4JLogger)NameNode.stateChangeLog;

    public TestFileCorruption() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileCorruption() throws Exception {
        MiniDFSCluster cluster = null;
        DFSTestUtil util = new DFSTestUtil("TestFileCorruption", 20, 3, 8192);
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            FileSystem fs = cluster.getFileSystem();
            util.createFiles(fs, "/srcdat");
            File storageDir = cluster.getInstanceStorageDir(2, 0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File data_dir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            TestFileCorruption.assertTrue((String)"data directory does not exist", (boolean)data_dir.exists());
            File[] blocks = data_dir.listFiles();
            TestFileCorruption.assertTrue((String)"Blocks do not exist in data-dir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
            for (int idx = 0; idx < blocks.length; ++idx) {
                if (!blocks[idx].getName().startsWith("blk_")) continue;
                System.out.println("Deliberately removing file " + blocks[idx].getName());
                TestFileCorruption.assertTrue((String)"Cannot remove file.", (boolean)blocks[idx].delete());
            }
            TestFileCorruption.assertTrue((String)"Corrupted replicas not handled properly.", (boolean)util.checkFiles(fs, "/srcdat"));
            util.cleanup(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testLocalFileCorruption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Path file = new Path(System.getProperty("test.build.data"), "corruptFile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Object dos = fs.create(file);
        ((DataOutputStream)dos).writeBytes("original bytes");
        ((FilterOutputStream)dos).close();
        dos = new DataOutputStream(new FileOutputStream(file.toString()));
        ((DataOutputStream)dos).writeBytes("corruption");
        ((FilterOutputStream)dos).close();
        FSDataInputStream dis = fs.open(file, 512);
        try {
            System.out.println("A ChecksumException is expected to be logged.");
            dis.readByte();
        }
        catch (ChecksumException ignore) {
            // empty catch block
        }
        fs.delete(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testArrayOutOfBoundsException() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            cluster.waitActive();
            FileSystem fs = cluster.getFileSystem();
            Path FILE_PATH = new Path("/tmp.txt");
            long FILE_LEN = 1L;
            DFSTestUtil.createFile(fs, FILE_PATH, 1L, (short)2, 1L);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            File storageDir = cluster.getInstanceStorageDir(0, 0);
            File dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
            ExtendedBlock blk = this.getBlock(bpid, dataDir);
            if (blk == null) {
                storageDir = cluster.getInstanceStorageDir(0, 1);
                dataDir = MiniDFSCluster.getFinalizedDir(storageDir, bpid);
                blk = this.getBlock(bpid, dataDir);
            }
            TestFileCorruption.assertFalse((blk == null ? 1 : 0) != 0);
            cluster.startDataNodes((Configuration)conf, 1, true, null, null);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            TestFileCorruption.assertEquals((int)datanodes.size(), (int)3);
            DataNode dataNode = datanodes.get(2);
            DatanodeRegistration dnR = DataNodeTestUtils.getDNRegistrationForBP(dataNode, blk.getBlockPoolId());
            cluster.getNamesystem().getBlockManager().findAndMarkBlockAsCorrupt(blk, new DatanodeInfo((DatanodeID)dnR), "TEST");
            fs.open(FILE_PATH);
            fs.delete(FILE_PATH, false);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private ExtendedBlock getBlock(String bpid, File dataDir) {
        int idx;
        TestFileCorruption.assertTrue((String)"data directory does not exist", (boolean)dataDir.exists());
        File[] blocks = dataDir.listFiles();
        TestFileCorruption.assertTrue((String)"Blocks do not exist in dataDir", (blocks != null && blocks.length > 0 ? 1 : 0) != 0);
        String blockFileName = null;
        for (idx = 0; idx < blocks.length && (!(blockFileName = blocks[idx].getName()).startsWith("blk_") || blockFileName.endsWith(".meta")); ++idx) {
        }
        if (blockFileName == null) {
            return null;
        }
        long blockId = Long.parseLong(blockFileName.substring("blk_".length()));
        long blockTimeStamp = 0L;
        for (idx = 0; idx < blocks.length; ++idx) {
            String fileName = blocks[idx].getName();
            if (!fileName.startsWith(blockFileName) || !fileName.endsWith(".meta")) continue;
            int startIndex = blockFileName.length() + 1;
            int endIndex = fileName.length() - ".meta".length();
            blockTimeStamp = Long.parseLong(fileName.substring(startIndex, endIndex));
            break;
        }
        return new ExtendedBlock(bpid, blockId, blocks[idx].length(), blockTimeStamp);
    }
}

