/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;

public class TestFileAppend2
extends TestCase {
    static final int numBlocks = 5;
    boolean simulatedStorage;
    private byte[] fileContents;
    int numDatanodes;
    int numberOfFiles;
    int numThreads;
    int numAppendsPerThread;
    Workload[] workload;
    final ArrayList<Path> testFiles;
    static volatile boolean globalStatus = true;

    public TestFileAppend2() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)NameNode.blockStateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        this.simulatedStorage = false;
        this.fileContents = null;
        this.numDatanodes = 6;
        this.numberOfFiles = 50;
        this.numThreads = 10;
        this.numAppendsPerThread = 20;
        this.workload = null;
        this.testFiles = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleAppend() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        if (this.simulatedStorage) {
            SimulatedFSDataset.setFactory((Configuration)conf);
        }
        conf.setInt("dfs.datanode.handler.count", 50);
        conf.setBoolean("dfs.support.append", true);
        this.fileContents = AppendTestUtil.initBuffer(10241);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fs = cluster.getFileSystem();
        try {
            int len;
            Path file1 = new Path("/simpleAppend.dat");
            FSDataOutputStream stm = AppendTestUtil.createFile(fs, file1, 1);
            System.out.println("Created file simpleAppend.dat");
            int mid = 186;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm.write(this.fileContents, 0, mid);
            stm.close();
            System.out.println("Wrote and Closed first part of file.");
            int mid2 = 607;
            System.out.println("Writing " + mid + " bytes to file " + file1);
            stm = fs.append(file1);
            stm.write(this.fileContents, mid, mid2 - mid);
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            stm = fs.append(file1);
            TestFileAppend2.assertTrue((stm.getPos() > 0L ? 1 : 0) != 0);
            System.out.println("Writing " + (10241 - mid2) + " bytes to file " + file1);
            stm.write(this.fileContents, mid2, 10241 - mid2);
            System.out.println("Written second part of file");
            stm.close();
            System.out.println("Wrote and Closed second part of file.");
            AppendTestUtil.checkFullFile(fs, file1, 10241, this.fileContents, "Read 2");
            FSDataOutputStream out = null;
            try {
                out = fs.append(new Path("/non-existing.dat"));
                TestFileAppend2.fail((String)"Expected to have FileNotFoundException");
            }
            catch (FileNotFoundException fnfe) {
                try {
                    System.out.println("Good: got " + fnfe);
                    fnfe.printStackTrace(System.out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)out);
            }
            IOUtils.closeStream((Closeable)out);
            Path root = new Path("/");
            fs.setPermission(root, new FsPermission(511));
            fs.close();
            UserGroupInformation superuser = UserGroupInformation.getCurrentUser();
            String username = "testappenduser";
            String group = "testappendgroup";
            TestFileAppend2.assertFalse((boolean)superuser.getShortUserName().equals(username));
            TestFileAppend2.assertFalse((boolean)Arrays.asList(superuser.getGroupNames()).contains(group));
            UserGroupInformation appenduser = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{group});
            fs = DFSTestUtil.getFileSystemAs(appenduser, (Configuration)conf);
            Path dir = new Path(root, ((Object)((Object)this)).getClass().getSimpleName());
            Path foo = new Path(dir, "foo.dat");
            FSDataOutputStream out2 = null;
            int offset = 0;
            try {
                out2 = fs.create(foo);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(dir, new FsPermission(64));
            fs.setPermission(foo, new FsPermission(128));
            out2 = null;
            try {
                out2 = fs.append(foo);
                len = 10 + AppendTestUtil.nextInt(100);
                out2.write(this.fileContents, offset, len);
                offset += len;
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
            fs.setPermission(foo, new FsPermission(383));
            fs.setPermission(dir, new FsPermission(511));
            out2 = null;
            try {
                out2 = fs.append(foo);
                TestFileAppend2.fail((String)"Expected to have AccessControlException");
            }
            catch (AccessControlException ace) {
                System.out.println("Good: got " + (Object)((Object)ace));
                ace.printStackTrace(System.out);
            }
            finally {
                IOUtils.closeStream((Closeable)out2);
            }
        }
        catch (IOException e) {
            System.out.println("Exception :" + e);
            throw e;
        }
        catch (Throwable e) {
            System.out.println("Throwable :" + e);
            e.printStackTrace();
            throw new IOException("Throwable : " + e);
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexAppend() throws IOException {
        this.fileContents = AppendTestUtil.initBuffer(10241);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 2000);
        conf.setInt("dfs.heartbeat.interval", 2);
        conf.setInt("dfs.namenode.replication.pending.timeout-sec", 2);
        conf.setInt("dfs.client.socket-timeout", 30000);
        conf.setInt("dfs.datanode.socket.write.timeout", 30000);
        conf.setInt("dfs.datanode.handler.count", 50);
        conf.setBoolean("dfs.support.append", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(this.numDatanodes).build();
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        try {
            int i;
            for (i = 0; i < this.numberOfFiles; ++i) {
                int replication = AppendTestUtil.nextInt(this.numDatanodes - 2) + 1;
                Path testFile = new Path("/" + i + ".dat");
                FSDataOutputStream stm = AppendTestUtil.createFile(fs, testFile, replication);
                stm.close();
                this.testFiles.add(testFile);
            }
            this.workload = new Workload[this.numThreads];
            for (i = 0; i < this.numThreads; ++i) {
                this.workload[i] = new Workload(cluster, i);
                this.workload[i].start();
            }
            for (i = 0; i < this.numThreads; ++i) {
                try {
                    System.out.println("Waiting for thread " + i + " to complete...");
                    this.workload[i].join();
                    System.out.println("Waiting for thread " + i + " complete.");
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
        }
        finally {
            fs.close();
            cluster.shutdown();
        }
        TestFileAppend2.assertTrue((String)"testComplexAppend Worker encountered exceptions.", (boolean)globalStatus);
    }

    class Workload
    extends Thread {
        private int id;
        private MiniDFSCluster cluster;

        Workload(MiniDFSCluster cluster, int threadIndex) {
            this.id = threadIndex;
            this.cluster = cluster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("Workload " + this.id + " starting... ");
            for (int i = 0; i < TestFileAppend2.this.numAppendsPerThread; ++i) {
                Path testfile;
                ArrayList<Path> arrayList = TestFileAppend2.this.testFiles;
                synchronized (arrayList) {
                    if (TestFileAppend2.this.testFiles.size() == 0) {
                        System.out.println("Completed write to almost all files.");
                        return;
                    }
                    int index = AppendTestUtil.nextInt(TestFileAppend2.this.testFiles.size());
                    testfile = TestFileAppend2.this.testFiles.remove(index);
                }
                long len = 0L;
                int sizeToAppend = 0;
                try {
                    FileSystem fs = this.cluster.getFileSystem();
                    len = fs.getFileStatus(testfile).getLen();
                    if (len >= 10241L) {
                        System.out.println("File " + testfile + " is full.");
                        continue;
                    }
                    int left = (int)(10241L - len) / 3;
                    if (left <= 0) {
                        left = 1;
                    }
                    sizeToAppend = AppendTestUtil.nextInt(left);
                    System.out.println("Workload thread " + this.id + " appending " + sizeToAppend + " bytes " + " to file " + testfile + " of size " + len);
                    FSDataOutputStream stm = fs.append(testfile);
                    stm.write(TestFileAppend2.this.fileContents, (int)len, sizeToAppend);
                    stm.close();
                    while (fs.getFileStatus(testfile).getLen() != len + (long)sizeToAppend) {
                        try {
                            System.out.println("Workload thread " + this.id + " file " + testfile + " size " + fs.getFileStatus(testfile).getLen() + " expected size " + (len + (long)sizeToAppend) + " waiting for namenode metadata update.");
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    Assert.assertTrue((String)("File " + testfile + " size is " + fs.getFileStatus(testfile).getLen() + " but expected " + (len + (long)sizeToAppend)), (fs.getFileStatus(testfile).getLen() == len + (long)sizeToAppend ? 1 : 0) != 0);
                    AppendTestUtil.checkFullFile(fs, testfile, (int)(len + (long)sizeToAppend), TestFileAppend2.this.fileContents, "Read 2");
                }
                catch (Throwable e) {
                    globalStatus = false;
                    if (e != null && e.toString() != null) {
                        System.out.println("Workload exception " + this.id + " testfile " + testfile + " " + e);
                        e.printStackTrace();
                    }
                    Assert.assertTrue((String)("Workload exception " + this.id + " testfile " + testfile + " expected size " + (len + (long)sizeToAppend)), (boolean)false);
                }
                ArrayList<Path> arrayList2 = TestFileAppend2.this.testFiles;
                synchronized (arrayList2) {
                    TestFileAppend2.this.testFiles.add(testfile);
                    continue;
                }
            }
        }
    }
}

