/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestFSOutputSummer
extends TestCase {
    private static final long seed = 3735928559L;
    private static final int BYTES_PER_CHECKSUM = 10;
    private static final int BLOCK_SIZE = 20;
    private static final int HALF_CHUNK_SIZE = 5;
    private static final int FILE_SIZE = 39;
    private static final short NUM_OF_DATANODES = 2;
    private byte[] expected = new byte[39];
    private byte[] actual = new byte[39];
    private FileSystem fileSys;

    private void writeFile1(Path name) throws Exception {
        FSDataOutputStream stm = this.fileSys.create(name, true, this.fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)2, 20L);
        stm.write(this.expected);
        stm.close();
        this.checkFile(name);
        this.cleanupFile(name);
    }

    private void writeFile2(Path name) throws Exception {
        int i;
        FSDataOutputStream stm = this.fileSys.create(name, true, this.fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)2, 20L);
        for (i = 0; i < 29; i += 10) {
            stm.write(this.expected, i, 10);
        }
        stm.write(this.expected, i, 9);
        stm.close();
        this.checkFile(name);
        this.cleanupFile(name);
    }

    private void writeFile3(Path name) throws Exception {
        FSDataOutputStream stm = this.fileSys.create(name, true, this.fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)2, 20L);
        stm.write(this.expected, 0, 5);
        stm.write(this.expected, 5, 12);
        stm.write(this.expected, 17, 2);
        stm.write(this.expected, 19, 5);
        stm.write(this.expected, 24, 6);
        stm.write(this.expected, 30, 9);
        stm.close();
        this.checkFile(name);
        this.cleanupFile(name);
    }

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) throws Exception {
        for (int idx = 0; idx < actual.length; ++idx) {
            TestFSOutputSummer.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (byte)actual[idx], (byte)expected[from + idx]);
            actual[idx] = 0;
        }
    }

    private void checkFile(Path name) throws Exception {
        FSDataInputStream stm = this.fileSys.open(name);
        stm.readFully(0L, this.actual);
        this.checkAndEraseData(this.actual, 0, this.expected, "Read Sanity Test");
        stm.close();
    }

    private void cleanupFile(Path name) throws IOException {
        TestFSOutputSummer.assertTrue((boolean)this.fileSys.exists(name));
        this.fileSys.delete(name, true);
        TestFSOutputSummer.assertTrue((!this.fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFSOutputSummer() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 20L);
        conf.setInt("dfs.bytes-per-checksum", 10);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        this.fileSys = cluster.getFileSystem();
        try {
            Path file = new Path("try.dat");
            Random rand = new Random(3735928559L);
            rand.nextBytes(this.expected);
            this.writeFile1(file);
            this.writeFile2(file);
            this.writeFile3(file);
        }
        finally {
            this.fileSys.close();
            cluster.shutdown();
        }
    }
}

