/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class TestDefaultNameNodePort
extends TestCase {
    public void testGetAddressFromString() throws Exception {
        TestDefaultNameNodePort.assertEquals((int)NameNode.getAddress((String)"foo").getPort(), (int)8020);
        TestDefaultNameNodePort.assertEquals((int)NameNode.getAddress((String)"hdfs://foo/").getPort(), (int)8020);
        TestDefaultNameNodePort.assertEquals((int)NameNode.getAddress((String)"hdfs://foo:555").getPort(), (int)555);
        TestDefaultNameNodePort.assertEquals((int)NameNode.getAddress((String)"foo:555").getPort(), (int)555);
    }

    public void testGetAddressFromConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo/");
        TestDefaultNameNodePort.assertEquals((int)NameNode.getAddress((Configuration)conf).getPort(), (int)8020);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://foo:555/");
        TestDefaultNameNodePort.assertEquals((int)NameNode.getAddress((Configuration)conf).getPort(), (int)555);
        FileSystem.setDefaultUri((Configuration)conf, (String)"foo");
        TestDefaultNameNodePort.assertEquals((int)NameNode.getAddress((Configuration)conf).getPort(), (int)8020);
    }

    public void testGetUri() {
        TestDefaultNameNodePort.assertEquals((Object)NameNode.getUri((InetSocketAddress)new InetSocketAddress("foo", 555)), (Object)URI.create("hdfs://foo:555"));
        TestDefaultNameNodePort.assertEquals((Object)NameNode.getUri((InetSocketAddress)new InetSocketAddress("foo", 8020)), (Object)URI.create("hdfs://foo"));
    }
}

