/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.security.Permission;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.mockito.Mockito;

public class TestDatanodeRegistration
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDNSLookups() throws Exception {
        MonitorDNS sm = new MonitorDNS();
        System.setSecurityManager(sm);
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(8).build();
            cluster.waitActive();
            int initialLookups = sm.lookups;
            TestDatanodeRegistration.assertTrue((String)"dns security manager is active", (initialLookups != 0 ? 1 : 0) != 0);
            DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
            dm.refreshNodes((Configuration)conf);
            TestDatanodeRegistration.assertEquals((int)initialLookups, (int)sm.lookups);
            dm.refreshNodes((Configuration)conf);
            TestDatanodeRegistration.assertEquals((int)initialLookups, (int)sm.lookups);
            dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.ALL);
            TestDatanodeRegistration.assertEquals((int)initialLookups, (int)sm.lookups);
            dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.LIVE);
            TestDatanodeRegistration.assertEquals((int)initialLookups, (int)sm.lookups);
            dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.DEAD);
            TestDatanodeRegistration.assertEquals((int)initialLookups, (int)sm.lookups);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            System.setSecurityManager(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeIpcPort() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)conf);
            cluster.restartDataNodes();
            DatanodeInfo[] report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            long firstUpdateAfterRestart = report[0].getLastUpdate();
            boolean gotHeartbeat = false;
            for (int i = 0; i < 10 && !gotHeartbeat; ++i) {
                try {
                    Thread.sleep(i * 1000);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
                gotHeartbeat = report[0].getLastUpdate() > firstUpdateAfterRestart;
            }
            if (!gotHeartbeat) {
                TestDatanodeRegistration.fail((String)"Never got a heartbeat from restarted datanode.");
            }
            int realIpcPort = cluster.getDataNodes().get(0).getIpcPort();
            TestDatanodeRegistration.assertEquals((int)realIpcPort, (int)report[0].getIpcPort());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeStorageID() throws Exception {
        String DN_IP_ADDR = "127.0.0.1";
        int DN_XFER_PORT = 12345;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            InetSocketAddress addr = new InetSocketAddress("localhost", cluster.getNameNodePort());
            DFSClient client = new DFSClient(addr, (Configuration)conf);
            NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            String nodeName = "127.0.0.1:12345";
            long nnCTime = cluster.getNameNodeRpc().versionRequest().getCTime();
            StorageInfo mockStorageInfo = (StorageInfo)Mockito.mock(StorageInfo.class);
            ((StorageInfo)Mockito.doReturn((Object)nnCTime).when((Object)mockStorageInfo)).getCTime();
            ((StorageInfo)Mockito.doReturn((Object)HdfsConstants.LAYOUT_VERSION).when((Object)mockStorageInfo)).getLayoutVersion();
            ((StorageInfo)Mockito.doReturn((Object)"fake-storage-id").when((Object)mockStorageInfo)).getClusterID();
            DatanodeRegistration dnReg = new DatanodeRegistration(nodeName);
            dnReg.storageInfo = mockStorageInfo;
            rpcServer.registerDatanode(dnReg);
            DatanodeInfo[] report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            TestDatanodeRegistration.assertEquals((String)"Expected a registered datanode", (int)1, (int)report.length);
            ((StorageInfo)Mockito.doReturn((Object)"changed-fake-storage-id").when((Object)mockStorageInfo)).getClusterID();
            dnReg = new DatanodeRegistration(nodeName);
            dnReg.storageInfo = mockStorageInfo;
            rpcServer.registerDatanode(dnReg);
            report = client.datanodeReport(HdfsConstants.DatanodeReportType.ALL);
            TestDatanodeRegistration.assertEquals((String)"Datanode with changed storage ID not recognized", (int)1, (int)report.length);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static class MonitorDNS
    extends SecurityManager {
        int lookups = 0;

        private MonitorDNS() {
        }

        @Override
        public void checkPermission(Permission perm) {
        }

        @Override
        public void checkConnect(String host, int port) {
            if (port == -1) {
                ++this.lookups;
            }
        }
    }
}

