/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSUtil {
    @Test
    public void testLocatedBlocks2Locations() {
        DatanodeInfo d = new DatanodeInfo();
        DatanodeInfo[] ds = new DatanodeInfo[]{d};
        ExtendedBlock b1 = new ExtendedBlock("bpid", 1L, 1L, 1L);
        LocatedBlock l1 = new LocatedBlock(b1, ds, 0L, false);
        ExtendedBlock b2 = new ExtendedBlock("bpid", 2L, 1L, 1L);
        LocatedBlock l2 = new LocatedBlock(b2, ds, 0L, true);
        List<LocatedBlock> ls = Arrays.asList(l1, l2);
        LocatedBlocks lbs = new LocatedBlocks(10L, false, ls, l2, true);
        BlockLocation[] bs = DFSUtil.locatedBlocks2Locations((LocatedBlocks)lbs);
        Assert.assertTrue((String)("expected 2 blocks but got " + bs.length), (bs.length == 2 ? 1 : 0) != 0);
        int corruptCount = 0;
        for (BlockLocation b : bs) {
            if (!b.isCorrupt()) continue;
            ++corruptCount;
        }
        Assert.assertTrue((String)("expected 1 corrupt files but got " + corruptCount), (corruptCount == 1 ? 1 : 0) != 0);
        bs = DFSUtil.locatedBlocks2Locations((LocatedBlocks)new LocatedBlocks());
        Assert.assertEquals((long)0L, (long)bs.length);
    }

    private Configuration setupAddress(String key) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.nameservices", "nn1");
        conf.set(DFSUtil.getNameServiceIdKey((String)key, (String)"nn1"), "localhost:9000");
        return conf;
    }

    @Test
    public void getNameServiceId() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.nameservice.id", "nn1");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
    }

    @Test
    public void getNameNodeNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.rpc-address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getNamenodeNameServiceId((Configuration)conf));
    }

    @Test
    public void getBackupNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.backup.address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getBackupNameServiceId((Configuration)conf));
    }

    @Test
    public void getSecondaryNameServiceId() {
        Configuration conf = this.setupAddress("dfs.namenode.secondary.http-address");
        Assert.assertEquals((Object)"nn1", (Object)DFSUtil.getSecondaryNameServiceId((Configuration)conf));
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testGetNameServiceIdException() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.nameservices", "nn1,nn2");
        conf.set(DFSUtil.getNameServiceIdKey((String)"dfs.namenode.rpc-address", (String)"nn1"), "localhost:9000");
        conf.set(DFSUtil.getNameServiceIdKey((String)"dfs.namenode.rpc-address", (String)"nn2"), "localhost:9001");
        DFSUtil.getNamenodeNameServiceId((Configuration)conf);
        Assert.fail((String)"Expected exception is not thrown");
    }

    @Test
    public void testGetNameServiceIds() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.nameservices", "nn1,nn2");
        Collection nameserviceIds = DFSUtil.getNameServiceIds((Configuration)conf);
        Iterator it = nameserviceIds.iterator();
        Assert.assertEquals((long)2L, (long)nameserviceIds.size());
        Assert.assertEquals((Object)"nn1", (Object)((String)it.next()).toString());
        Assert.assertEquals((Object)"nn2", (Object)((String)it.next()).toString());
    }

    @Test
    public void testMultipleNamenodes() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.nameservices", "nn1,nn2");
        String NN1_ADDRESS = "localhost:9000";
        String NN2_ADDRESS = "localhost:9001";
        String NN3_ADDRESS = "localhost:9002";
        conf.set(DFSUtil.getNameServiceIdKey((String)"dfs.namenode.rpc-address", (String)"nn1"), "localhost:9000");
        conf.set(DFSUtil.getNameServiceIdKey((String)"dfs.namenode.rpc-address", (String)"nn2"), "localhost:9001");
        List nnAddresses = DFSUtil.getNNServiceRpcAddresses((Configuration)conf);
        Assert.assertEquals((long)2L, (long)nnAddresses.size());
        Iterator iterator = nnAddresses.iterator();
        InetSocketAddress addr = (InetSocketAddress)iterator.next();
        Assert.assertEquals((Object)"localhost", (Object)addr.getHostName());
        Assert.assertEquals((long)9000L, (long)addr.getPort());
        addr = (InetSocketAddress)iterator.next();
        Assert.assertEquals((Object)"localhost", (Object)addr.getHostName());
        Assert.assertEquals((long)9001L, (long)addr.getPort());
        this.checkNameServiceId((Configuration)conf, "localhost:9000", "nn1");
        this.checkNameServiceId((Configuration)conf, "localhost:9001", "nn2");
        this.checkNameServiceId((Configuration)conf, "localhost:9002", null);
    }

    public void checkNameServiceId(Configuration conf, String addr, String expectedNameServiceId) {
        InetSocketAddress s = NetUtils.createSocketAddr((String)addr);
        String nameserviceId = DFSUtil.getNameServiceIdFromAddress((Configuration)conf, (InetSocketAddress)s, (String[])new String[]{"dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address"});
        Assert.assertEquals((Object)expectedNameServiceId, (Object)nameserviceId);
    }

    @Test
    public void testSingleNamenode() {
        HdfsConfiguration conf = new HdfsConfiguration();
        String DEFAULT_ADDRESS = "localhost:9000";
        String NN2_ADDRESS = "localhost:9001";
        conf.set("dfs.namenode.rpc-address", "localhost:9000");
        InetSocketAddress testAddress1 = NetUtils.createSocketAddr((String)"localhost:9000");
        boolean isDefault = DFSUtil.isDefaultNamenodeAddress((Configuration)conf, (InetSocketAddress)testAddress1, (String[])new String[]{"dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address"});
        Assert.assertTrue((boolean)isDefault);
        InetSocketAddress testAddress2 = NetUtils.createSocketAddr((String)"localhost:9001");
        isDefault = DFSUtil.isDefaultNamenodeAddress((Configuration)conf, (InetSocketAddress)testAddress2, (String[])new String[]{"dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address"});
        Assert.assertFalse((boolean)isDefault);
    }

    @Test
    public void testDefaultNamenode() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String hdfs_default = "hdfs://localhost:9999/";
        conf.set("fs.defaultFS", "hdfs://localhost:9999/");
        List addrList = DFSUtil.getNNServiceRpcAddresses((Configuration)conf);
        Assert.assertEquals((long)1L, (long)addrList.size());
        Assert.assertEquals((long)9999L, (long)((InetSocketAddress)addrList.get(0)).getPort());
    }

    @Test
    public void testConfModification() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.nameservices", "nn1");
        conf.set("dfs.federation.nameservice.id", "nn1");
        String nameserviceId = DFSUtil.getNamenodeNameServiceId((Configuration)conf);
        for (String key : NameNode.NAMESERVICE_SPECIFIC_KEYS) {
            conf.set(DFSUtil.getNameServiceIdKey((String)key, (String)nameserviceId), key);
        }
        NameNode.initializeGenericKeys((Configuration)conf, (String)nameserviceId);
        for (String key : NameNode.NAMESERVICE_SPECIFIC_KEYS) {
            Assert.assertEquals((Object)key, (Object)conf.get(key));
        }
    }

    @Test
    public void testEmptyConf() {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        try {
            DFSUtil.getNNServiceRpcAddresses((Configuration)conf);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            DFSUtil.getBackupNodeAddresses((Configuration)conf);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            DFSUtil.getSecondaryNameNodeAddresses((Configuration)conf);
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetServerInfo() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        String httpsport = DFSUtil.getInfoServer(null, (Configuration)conf, (boolean)true);
        Assert.assertEquals((Object)"0.0.0.0:50470", (Object)httpsport);
        String httpport = DFSUtil.getInfoServer(null, (Configuration)conf, (boolean)false);
        Assert.assertEquals((Object)"0.0.0.0:50070", (Object)httpport);
    }

    @Test
    public void testIsValidName() {
        Assert.assertFalse((boolean)DFSUtil.isValidName((String)"/foo/../bar"));
        Assert.assertFalse((boolean)DFSUtil.isValidName((String)"/foo//bar"));
        Assert.assertTrue((boolean)DFSUtil.isValidName((String)"/"));
        Assert.assertTrue((boolean)DFSUtil.isValidName((String)"/bar/"));
    }
}

