/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;

public class TestDFSStorageStateRecovery
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSStorageStateRecovery");
    private Configuration conf = null;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;
    private static final int CURRENT_EXISTS = 0;
    private static final int PREVIOUS_EXISTS = 1;
    private static final int PREVIOUS_TMP_EXISTS = 2;
    private static final int REMOVED_TMP_EXISTS = 3;
    private static final int SHOULD_RECOVER = 4;
    private static final int CURRENT_SHOULD_EXIST_AFTER_RECOVER = 5;
    private static final int PREVIOUS_SHOULD_EXIST_AFTER_RECOVER = 6;
    static boolean[][] testCases = new boolean[][]{{true, false, false, false, true, true, false}, {true, true, false, false, true, true, true}, {true, false, true, false, true, true, true}, {true, true, true, true, false, false, false}, {true, true, true, false, false, false, false}, {false, true, true, true, false, false, false}, {false, true, true, false, false, false, false}, {false, false, false, false, false, false, false}, {false, true, false, false, false, false, false}, {false, false, true, false, true, true, false}, {true, false, false, true, true, true, false}, {true, true, false, true, false, false, false}, {true, true, true, true, false, false, false}, {true, false, true, true, false, false, false}, {false, true, true, true, false, false, false}, {false, false, true, true, false, false, false}, {false, false, false, true, false, false, false}, {false, true, false, true, true, true, true}, {true, true, false, false, true, true, false}};
    private static final int NUM_NN_TEST_CASES = testCases.length;
    private static final int NUM_DN_TEST_CASES = 18;

    void log(String label, int numDirs, int testCaseNum, boolean[] state) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs + " testCase=" + testCaseNum + " current=" + state[0] + " previous=" + state[1] + " previous.tmp=" + state[2] + " removed.tmp=" + state[3] + " should recover=" + state[4] + " current exists after=" + state[5] + " previous exists after=" + state[6]));
    }

    String[] createNameNodeStorageState(boolean[] state) throws Exception {
        String[] baseDirs = this.conf.getStrings("dfs.namenode.name.dir");
        UpgradeUtilities.createEmptyDirs(baseDirs);
        if (state[0]) {
            UpgradeUtilities.createNameNodeStorageDirs(baseDirs, "current");
        }
        if (state[1]) {
            UpgradeUtilities.createNameNodeStorageDirs(baseDirs, "previous");
        }
        if (state[2]) {
            UpgradeUtilities.createNameNodeStorageDirs(baseDirs, "previous.tmp");
        }
        if (state[3]) {
            UpgradeUtilities.createNameNodeStorageDirs(baseDirs, "removed.tmp");
        }
        return baseDirs;
    }

    String[] createDataNodeStorageState(boolean[] state) throws Exception {
        String[] baseDirs = this.conf.getStrings("dfs.datanode.data.dir");
        UpgradeUtilities.createEmptyDirs(baseDirs);
        if (state[0]) {
            UpgradeUtilities.createDataNodeStorageDirs(baseDirs, "current");
        }
        if (state[1]) {
            UpgradeUtilities.createDataNodeStorageDirs(baseDirs, "previous");
        }
        if (state[2]) {
            UpgradeUtilities.createDataNodeStorageDirs(baseDirs, "previous.tmp");
        }
        if (state[3]) {
            UpgradeUtilities.createDataNodeStorageDirs(baseDirs, "removed.tmp");
        }
        return baseDirs;
    }

    String[] createBlockPoolStorageState(String bpid, boolean[] state) throws Exception {
        String[] baseDirs = this.conf.getStrings("dfs.datanode.data.dir");
        UpgradeUtilities.createEmptyDirs(baseDirs);
        UpgradeUtilities.createDataNodeStorageDirs(baseDirs, "current");
        String[] bpDirs = UpgradeUtilities.createEmptyBPDirs(baseDirs, bpid);
        if (state[0]) {
            UpgradeUtilities.createBlockPoolStorageDirs(baseDirs, "current", bpid);
        }
        if (state[1]) {
            UpgradeUtilities.createBlockPoolStorageDirs(baseDirs, "previous", bpid);
        }
        if (state[2]) {
            UpgradeUtilities.createBlockPoolStorageDirs(baseDirs, "previous.tmp", bpid);
        }
        if (state[3]) {
            UpgradeUtilities.createBlockPoolStorageDirs(baseDirs, "removed.tmp", bpid);
        }
        return bpDirs;
    }

    void checkResultNameNode(String[] baseDirs, boolean currentShouldExist, boolean previousShouldExist) throws IOException {
        int i;
        if (currentShouldExist) {
            for (i = 0; i < baseDirs.length; ++i) {
                TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current").isDirectory());
                TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current/VERSION").isFile());
                TestDFSStorageStateRecovery.assertNotNull((Object)FSImageTestUtil.findNewestImageFile(baseDirs[i] + "/current"));
                TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "current/seen_txid").isFile());
            }
        }
        if (previousShouldExist) {
            for (i = 0; i < baseDirs.length; ++i) {
                TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "previous").isDirectory());
                TestDFSStorageStateRecovery.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.NAME_NODE, new File(baseDirs[i], "previous")), (long)UpgradeUtilities.checksumMasterNameNodeContents());
            }
        }
    }

    void checkResultDataNode(String[] baseDirs, boolean currentShouldExist, boolean previousShouldExist) throws IOException {
        int i;
        if (currentShouldExist) {
            for (i = 0; i < baseDirs.length; ++i) {
                TestDFSStorageStateRecovery.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, new File(baseDirs[i], "current")), (long)UpgradeUtilities.checksumMasterDataNodeContents());
            }
        }
        if (previousShouldExist) {
            for (i = 0; i < baseDirs.length; ++i) {
                TestDFSStorageStateRecovery.assertTrue((boolean)new File(baseDirs[i], "previous").isDirectory());
                TestDFSStorageStateRecovery.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, new File(baseDirs[i], "previous")), (long)UpgradeUtilities.checksumMasterDataNodeContents());
            }
        }
    }

    void checkResultBlockPool(String[] baseDirs, boolean currentShouldExist, boolean previousShouldExist) throws IOException {
        int i;
        if (currentShouldExist) {
            for (i = 0; i < baseDirs.length; ++i) {
                File bpCurDir = new File(baseDirs[i], "current");
                TestDFSStorageStateRecovery.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, bpCurDir), (long)UpgradeUtilities.checksumMasterBlockPoolContents());
            }
        }
        if (previousShouldExist) {
            for (i = 0; i < baseDirs.length; ++i) {
                File bpPrevDir = new File(baseDirs[i], "previous");
                TestDFSStorageStateRecovery.assertTrue((boolean)bpPrevDir.isDirectory());
                TestDFSStorageStateRecovery.assertEquals((long)UpgradeUtilities.checksumContents(HdfsServerConstants.NodeType.DATA_NODE, bpPrevDir), (long)UpgradeUtilities.checksumMasterBlockPoolContents());
            }
        }
    }

    private MiniDFSCluster createCluster(Configuration c) throws IOException {
        return new MiniDFSCluster.Builder(c).numDataNodes(0).startupOption(HdfsServerConstants.StartupOption.REGULAR).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).build();
    }

    public void testNNStorageStates() throws Exception {
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            for (int i = 0; i < NUM_NN_TEST_CASES; ++i) {
                block6: {
                    boolean[] testCase = testCases[i];
                    boolean shouldRecover = testCase[4];
                    boolean curAfterRecover = testCase[5];
                    boolean prevAfterRecover = testCase[6];
                    this.log("NAME_NODE recovery", numDirs, i, testCase);
                    String[] baseDirs = this.createNameNodeStorageState(testCase);
                    if (shouldRecover) {
                        this.cluster = this.createCluster(this.conf);
                        this.checkResultNameNode(baseDirs, curAfterRecover, prevAfterRecover);
                        this.cluster.shutdown();
                    } else {
                        try {
                            this.cluster = this.createCluster(this.conf);
                            throw new AssertionError((Object)"NameNode should have failed to start");
                        }
                        catch (IOException expected) {
                            if (testCases[i][0] || testCases[i][2] || testCases[i][1] || testCases[i][3]) break block6;
                            TestDFSStorageStateRecovery.assertTrue((boolean)expected.getLocalizedMessage().contains("NameNode is not formatted"));
                        }
                    }
                }
                this.cluster.shutdown();
            }
        }
    }

    public void testDNStorageStates() throws Exception {
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            for (int i = 0; i < 18; ++i) {
                boolean[] testCase = testCases[i];
                boolean shouldRecover = testCase[4];
                boolean curAfterRecover = testCase[5];
                boolean prevAfterRecover = testCase[6];
                this.log("DATA_NODE recovery", numDirs, i, testCase);
                this.createNameNodeStorageState(new boolean[]{true, true, false, false, false});
                this.cluster = this.createCluster(this.conf);
                String[] baseDirs = this.createDataNodeStorageState(testCase);
                if (!(testCase[0] || testCase[1] || testCase[2] || testCase[3])) {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
                } else if (shouldRecover) {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
                    this.checkResultDataNode(baseDirs, curAfterRecover, prevAfterRecover);
                } else {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
                    TestDFSStorageStateRecovery.assertFalse((boolean)this.cluster.getDataNodes().get(0).isDatanodeUp());
                }
                this.cluster.shutdown();
            }
        }
    }

    public void testBlockPoolStorageStates() throws Exception {
        String bpid = UpgradeUtilities.getCurrentBlockPoolID(null);
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            for (int i = 0; i < 18; ++i) {
                boolean[] testCase = testCases[i];
                boolean shouldRecover = testCase[4];
                boolean curAfterRecover = testCase[5];
                boolean prevAfterRecover = testCase[6];
                this.log("BLOCK_POOL recovery", numDirs, i, testCase);
                this.createNameNodeStorageState(new boolean[]{true, true, false, false, false});
                this.cluster = this.createCluster(this.conf);
                String[] baseDirs = this.createBlockPoolStorageState(bpid, testCase);
                if (!(testCase[0] || testCase[1] || testCase[2] || testCase[3])) {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
                } else if (shouldRecover) {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
                    this.checkResultBlockPool(baseDirs, curAfterRecover, prevAfterRecover);
                } else {
                    this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
                    TestDFSStorageStateRecovery.assertFalse((boolean)this.cluster.getDataNodes().get(0).isBPServiceAlive(bpid));
                }
                this.cluster.shutdown();
            }
        }
    }

    protected void setUp() throws Exception {
        LOG.info((Object)"Setting up the directory structures.");
        UpgradeUtilities.initialize();
    }

    protected void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }
}

