/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;

public class TestDFSRename
extends TestCase {
    final Path dir = new Path("/test/rename/");

    static int countLease(MiniDFSCluster cluster) {
        return NameNodeAdapter.getLeaseManager(cluster.getNamesystem()).countLease();
    }

    void list(FileSystem fs, String name) throws IOException {
        FileSystem.LOG.info((Object)("\n\n" + name));
        for (FileStatus s : fs.listStatus(this.dir)) {
            FileSystem.LOG.info((Object)("" + s.getPath()));
        }
    }

    static void createFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream a_out = fs.create(f);
        a_out.writeBytes("something");
        a_out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRename() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            FileSystem fs = cluster.getFileSystem();
            TestDFSRename.assertTrue((boolean)fs.mkdirs(this.dir));
            Path a = new Path(this.dir, "a");
            Path aa = new Path(this.dir, "aa");
            Path b = new Path(this.dir, "b");
            TestDFSRename.createFile(fs, a);
            TestDFSRename.assertEquals((int)0, (int)TestDFSRename.countLease(cluster));
            FSDataOutputStream aa_out = fs.create(aa);
            aa_out.writeBytes("something");
            TestDFSRename.assertEquals((int)1, (int)TestDFSRename.countLease(cluster));
            this.list(fs, "rename0");
            fs.rename(a, b);
            this.list(fs, "rename1");
            aa_out.writeBytes(" more");
            aa_out.close();
            this.list(fs, "rename2");
            TestDFSRename.assertEquals((int)0, (int)TestDFSRename.countLease(cluster));
            Path dstPath = new Path("/c/d");
            TestDFSRename.assertFalse((boolean)fs.exists(dstPath));
            TestDFSRename.assertFalse((boolean)fs.rename(this.dir, dstPath));
            Path src = new Path("/a/b");
            Path dst = new Path("/a/b/c");
            TestDFSRename.createFile(fs, new Path(src, "foo"));
            TestDFSRename.assertFalse((boolean)fs.rename(src, dst));
            TestDFSRename.assertFalse((boolean)fs.rename(src.getParent(), dst.getParent()));
            src = new Path("/testPrefix");
            dst = new Path("/testPrefixfile");
            TestDFSRename.createFile(fs, src);
            TestDFSRename.assertTrue((boolean)fs.rename(src, dst));
            src = new Path("/a/b/c");
            TestDFSRename.createFile(fs, src);
            TestDFSRename.assertTrue((boolean)fs.rename(src, src));
            TestDFSRename.assertFalse((boolean)fs.rename(new Path("/a/b"), new Path("/a/b/")));
            TestDFSRename.assertTrue((boolean)fs.rename(src, new Path("/a/b/c/")));
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

