/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.junit.Test;

public class TestDFSMkdirs
extends TestCase {
    private Configuration conf = new HdfsConfiguration();
    private static final String[] NON_CANONICAL_PATHS = new String[]{"//test1", "/test2/..", "/test2//bar", "/test2/../test4", "/test5/."};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDFSMkdirs() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            Path myPath = new Path("/test/mkdirs");
            TestDFSMkdirs.assertTrue((boolean)fileSys.mkdirs(myPath));
            TestDFSMkdirs.assertTrue((boolean)fileSys.exists(myPath));
            TestDFSMkdirs.assertTrue((boolean)fileSys.mkdirs(myPath));
            Path myFile = new Path("/test/mkdirs/myFile");
            DFSTestUtil.writeFile(fileSys, myFile, "hello world");
            Path myIllegalPath = new Path("/test/mkdirs/myFile/subdir");
            Boolean exist = true;
            try {
                fileSys.mkdirs(myIllegalPath);
            }
            catch (IOException e) {
                exist = false;
            }
            TestDFSMkdirs.assertFalse((boolean)exist);
            TestDFSMkdirs.assertFalse((boolean)fileSys.exists(myIllegalPath));
            fileSys.delete(myFile, true);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMkdir() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = (DistributedFileSystem)cluster.getFileSystem();
        try {
            TestDFSMkdirs.assertTrue((boolean)dfs.mkdir(new Path("/mkdir-" + System.currentTimeMillis()), FsPermission.getDefault()));
            IOException expectedException = null;
            String filePath = "/mkdir-file-" + System.currentTimeMillis();
            DFSTestUtil.writeFile((FileSystem)dfs, new Path(filePath), "hello world");
            try {
                dfs.mkdir(new Path(filePath + "/mkdir"), FsPermission.getDefault());
            }
            catch (IOException e) {
                expectedException = e;
            }
            TestDFSMkdirs.assertTrue((String)"Create a directory when parent dir exists as file using mkdir() should throw ParentNotDirectoryException ", (expectedException != null && expectedException instanceof ParentNotDirectoryException ? 1 : 0) != 0);
            expectedException = null;
            try {
                dfs.mkdir(new Path("/non-exist/mkdir-" + System.currentTimeMillis()), FsPermission.getDefault());
            }
            catch (IOException e) {
                expectedException = e;
            }
            TestDFSMkdirs.assertTrue((String)"Create a directory in a non-exist parent dir using mkdir() should throw FileNotFoundException ", (expectedException != null && expectedException instanceof FileNotFoundException ? 1 : 0) != 0);
        }
        finally {
            dfs.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMkdirRpcNonCanonicalPath() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).build();
        try {
            NamenodeProtocols nnrpc = cluster.getNameNodeRpc();
            for (String pathStr : NON_CANONICAL_PATHS) {
                try {
                    nnrpc.mkdirs(pathStr, new FsPermission(493), true);
                    TestDFSMkdirs.fail((String)("Did not fail when called with a non-canonicalized path: " + pathStr));
                }
                catch (InvalidPathException ipe) {
                    // empty catch block
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

