/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;

public class TestBlocksScheduledCounter
extends TestCase {
    public void testBlocksScheduledCounter() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        cluster.waitActive();
        FileSystem fs = cluster.getFileSystem();
        FSDataOutputStream out = fs.create(new Path("/testBlockScheduledCounter"));
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        ((DFSOutputStream)out.getWrappedStream()).hflush();
        ArrayList dnList = new ArrayList();
        DatanodeManager dm = cluster.getNamesystem().getBlockManager().getDatanodeManager();
        dm.fetchDatanodes(dnList, dnList, false);
        DatanodeDescriptor dn = (DatanodeDescriptor)dnList.get(0);
        TestBlocksScheduledCounter.assertEquals((int)1, (int)dn.getBlocksScheduled());
        out.close();
        TestBlocksScheduledCounter.assertEquals((int)0, (int)dn.getBlocksScheduled());
    }
}

