/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestAppendDifferentChecksum {
    private static final int SEGMENT_LENGTH = 1500;
    private static final long RANDOM_TEST_RUNTIME = 5000L;
    private static MiniDFSCluster cluster;
    private static FileSystem fs;

    @BeforeClass
    public static void setupCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.blocksize", 4096);
        conf.set("fs.hdfs.impl.disable.cache", "true");
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void teardown() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    @Ignore(value="this is not implemented! See HDFS-2130")
    public void testSwitchChunkSize() throws IOException {
        FileSystem fsWithSmallChunk = this.createFsWithChecksum("CRC32", 512);
        FileSystem fsWithBigChunk = this.createFsWithChecksum("CRC32", 1024);
        Path p = new Path("/testSwitchChunkSize");
        this.appendWithTwoFs(p, fsWithSmallChunk, fsWithBigChunk);
        AppendTestUtil.check(fsWithSmallChunk, p, 3000L);
        AppendTestUtil.check(fsWithBigChunk, p, 3000L);
    }

    @Test
    public void testSwitchAlgorithms() throws IOException {
        FileSystem fsWithCrc32 = this.createFsWithChecksum("CRC32", 512);
        FileSystem fsWithCrc32C = this.createFsWithChecksum("CRC32C", 512);
        Path p = new Path("/testSwitchAlgorithms");
        this.appendWithTwoFs(p, fsWithCrc32, fsWithCrc32C);
        AppendTestUtil.check(fsWithCrc32C, p, 3000L);
        AppendTestUtil.check(fsWithCrc32, p, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testAlgoSwitchRandomized() throws IOException {
        FileSystem fsWithCrc32 = this.createFsWithChecksum("CRC32", 512);
        FileSystem fsWithCrc32C = this.createFsWithChecksum("CRC32C", 512);
        Path p = new Path("/testAlgoSwitchRandomized");
        long seed = System.currentTimeMillis();
        System.out.println("seed: " + seed);
        Random r = new Random(seed);
        IOUtils.closeStream((Closeable)fsWithCrc32.create(p));
        long st = System.currentTimeMillis();
        int len = 0;
        while (System.currentTimeMillis() - st < 5000L) {
            int thisLen = r.nextInt(500);
            FileSystem fs = r.nextBoolean() ? fsWithCrc32 : fsWithCrc32C;
            FSDataOutputStream stm = fs.append(p);
            try {
                AppendTestUtil.write((OutputStream)stm, len, thisLen);
            }
            finally {
                stm.close();
            }
            len += thisLen;
        }
        AppendTestUtil.check(fsWithCrc32, p, len);
        AppendTestUtil.check(fsWithCrc32C, p, len);
    }

    private FileSystem createFsWithChecksum(String type, int bytes) throws IOException {
        Configuration conf = new Configuration(fs.getConf());
        conf.set("dfs.checksum.type", type);
        conf.setInt("dfs.bytes-per-checksum", bytes);
        return FileSystem.get((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendWithTwoFs(Path p, FileSystem fs1, FileSystem fs2) throws IOException {
        FSDataOutputStream stm = fs1.create(p);
        try {
            AppendTestUtil.write((OutputStream)stm, 0, 1500);
        }
        finally {
            stm.close();
        }
        stm = fs2.append(p);
        try {
            AppendTestUtil.write((OutputStream)stm, 1500, 1500);
        }
        finally {
            stm.close();
        }
    }
}

