/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileAppendTest4 {
    public static final Log LOG = LogFactory.getLog(FileAppendTest4.class);
    private static final int BYTES_PER_CHECKSUM = 4;
    private static final int PACKET_SIZE = 4;
    private static final int BLOCK_SIZE = 8;
    private static final short REPLICATION = 3;
    private static final int DATANODE_NUM = 5;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;

    private static void init(Configuration conf) {
        conf.setInt("dfs.bytes-per-checksum", 4);
        conf.setLong("dfs.blocksize", 8L);
        conf.setInt("dfs.client-write-packet-size", 4);
        conf.setBoolean("dfs.support.append", true);
    }

    @BeforeClass
    public static void startUp() throws IOException {
        conf = new HdfsConfiguration();
        FileAppendTest4.init(conf);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(5).build();
        fs = (DistributedFileSystem)cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        cluster.shutdown();
    }

    @Test
    public void testAppend() throws IOException {
        int maxOldFileLen = 17;
        int maxFlushedBytes = 8;
        byte[] contents = AppendTestUtil.initBuffer(33);
        for (int oldFileLen = 0; oldFileLen <= 17; ++oldFileLen) {
            for (int flushedBytes1 = 0; flushedBytes1 <= 8; ++flushedBytes1) {
                for (int flushedBytes2 = 0; flushedBytes2 <= 8; ++flushedBytes2) {
                    int fileLen = oldFileLen + flushedBytes1 + flushedBytes2;
                    Path p = new Path("foo" + oldFileLen + "_" + flushedBytes1 + "_" + flushedBytes2);
                    LOG.info((Object)("Creating file " + p));
                    FSDataOutputStream out = fs.create(p, false, conf.getInt("io.file.buffer.size", 4096), (short)3, 8L);
                    out.write(contents, 0, oldFileLen);
                    out.close();
                    out = fs.append(p);
                    out.write(contents, oldFileLen, flushedBytes1);
                    out.hflush();
                    out.write(contents, oldFileLen + flushedBytes1, flushedBytes2);
                    out.close();
                    AppendTestUtil.checkFullFile((FileSystem)fs, p, fileLen, contents, p.toString());
                    fs.delete(p, false);
                }
            }
        }
    }
}

