/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.junit.Assert;

public class DFSTestUtil {
    private static Random gen = new Random();
    private static String[] dirNames = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private int maxLevels;
    private int maxSize;
    private int minSize = 1;
    private int nFiles;
    private MyFile[] files;

    public DFSTestUtil(String testName, int nFiles, int maxLevels, int maxSize) {
        this.nFiles = nFiles;
        this.maxLevels = maxLevels;
        this.maxSize = maxSize;
    }

    public static void formatNameNode(Configuration conf) throws IOException {
        String clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId();
        if (clusterId == null || clusterId.isEmpty()) {
            HdfsServerConstants.StartupOption.FORMAT.setClusterId("testClusterID");
        }
        NameNode.format((Configuration)conf);
    }

    public void createFiles(FileSystem fs, String topdir) throws IOException {
        this.createFiles(fs, topdir, (short)3);
    }

    public void createFiles(FileSystem fs, String topdir, short replicationFactor) throws IOException {
        this.files = new MyFile[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            this.files[idx] = new MyFile();
        }
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.createFile(fs, new Path(root, this.files[idx].getName()), this.files[idx].getSize(), replicationFactor, this.files[idx].getSeed());
        }
    }

    public static String readFile(FileSystem fs, Path fileName) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)fs.open(fileName), (OutputStream)os, (int)1024, (boolean)true);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileSystem fs, Path fileName, long fileLen, short replFactor, long seed) throws IOException {
        if (!fs.mkdirs(fileName.getParent())) {
            throw new IOException("Mkdirs failed to create " + fileName.getParent().toString());
        }
        FSDataOutputStream out = null;
        try {
            int bytesToWriteNext;
            out = fs.create(fileName, replFactor);
            byte[] toWrite = new byte[1024];
            Random rb = new Random(seed);
            for (long bytesToWrite = fileLen; bytesToWrite > 0L; bytesToWrite -= (long)bytesToWriteNext) {
                rb.nextBytes(toWrite);
                bytesToWriteNext = 1024L < bytesToWrite ? 1024 : (int)bytesToWrite;
                out.write(toWrite, 0, bytesToWriteNext);
            }
            out.close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
    }

    public boolean checkFiles(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            FSDataInputStream in = fs.open(fPath);
            byte[] toRead = new byte[this.files[idx].getSize()];
            byte[] toCompare = new byte[this.files[idx].getSize()];
            Random rb = new Random(this.files[idx].getSeed());
            rb.nextBytes(toCompare);
            in.readFully(0L, toRead);
            in.close();
            for (int i = 0; i < toRead.length; ++i) {
                if (toRead[i] == toCompare[i]) continue;
                return false;
            }
            toRead = null;
            toCompare = null;
        }
        return true;
    }

    void setReplication(FileSystem fs, String topdir, short value) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            Path fPath = new Path(root, this.files[idx].getName());
            fs.setReplication(fPath, value);
        }
    }

    public void waitReplication(FileSystem fs, String topdir, short value) throws IOException {
        Path root = new Path(topdir);
        for (int idx = 0; idx < this.nFiles; ++idx) {
            DFSTestUtil.waitReplication(fs, new Path(root, this.files[idx].getName()), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean allBlockReplicasCorrupt(MiniDFSCluster cluster, Path file, int blockNo) throws IOException {
        LocatedBlocks blocks;
        DFSClient client = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), cluster.getConfiguration(0));
        try {
            blocks = client.getNamenode().getBlockLocations(file.toString(), 0L, Long.MAX_VALUE);
        }
        finally {
            client.close();
        }
        return blocks.get(blockNo).isCorrupt();
    }

    public static void waitForReplication(MiniDFSCluster cluster, ExtendedBlock b, int racks, int replicas, int neededReplicas) throws IOException, TimeoutException, InterruptedException {
        int curRacks = 0;
        int curReplicas = 0;
        int curNeededReplicas = 0;
        int count = 0;
        int ATTEMPTS = 20;
        do {
            Thread.sleep(1000L);
            int[] r = BlockManagerTestUtil.getReplicaInfo(cluster.getNamesystem(), b.getLocalBlock());
            curRacks = r[0];
            curReplicas = r[1];
            curNeededReplicas = r[2];
        } while ((curRacks != racks || curReplicas != replicas || curNeededReplicas != neededReplicas) && ++count < 20);
        if (count == 20) {
            throw new TimeoutException("Timed out waiting for replication. Needed replicas = " + neededReplicas + " Cur needed replicas = " + curNeededReplicas + " Replicas = " + replicas + " Cur replicas = " + curReplicas + " Racks = " + racks + " Cur racks = " + curRacks);
        }
    }

    public static void waitCorruptReplicas(FileSystem fs, FSNamesystem ns, Path file, ExtendedBlock b, int corruptRepls) throws IOException, TimeoutException {
        int count;
        int ATTEMPTS = 50;
        int repls = ns.getBlockManager().numCorruptReplicas(b.getLocalBlock());
        for (count = 0; repls != corruptRepls && count < 50; ++count) {
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (int)512, (boolean)true);
            }
            catch (IOException e) {
                // empty catch block
            }
            System.out.println("Waiting for " + corruptRepls + " corrupt replicas");
            repls = ns.getBlockManager().numCorruptReplicas(b.getLocalBlock());
        }
        if (count == 50) {
            throw new TimeoutException("Timed out waiting for corrupt replicas. Waiting for " + corruptRepls + ", but only found " + repls);
        }
    }

    public static void waitForDecommission(FileSystem fs, String name) throws IOException, InterruptedException, TimeoutException {
        DatanodeInfo dn = null;
        int count = 0;
        int ATTEMPTS = 20;
        do {
            Thread.sleep(1000L);
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            for (DatanodeInfo info : dfs.getDataNodeStats()) {
                if (!name.equals(info.getName())) continue;
                dn = info;
            }
        } while ((dn == null || dn.isDecommissionInProgress() || !dn.isDecommissioned()) && ++count < 20);
        if (count == 20) {
            throw new TimeoutException("Timed out waiting for datanode " + name + " to decommission.");
        }
    }

    public static int firstDnWithBlock(MiniDFSCluster cluster, ExtendedBlock b) throws IOException {
        int numDatanodes = cluster.getDataNodes().size();
        for (int i = 0; i < numDatanodes; ++i) {
            String blockContent = cluster.readBlockOnDataNode(i, b);
            if (blockContent == null) continue;
            return i;
        }
        return -1;
    }

    public static long getLiveDatanodeCapacity(DatanodeManager dm) {
        ArrayList live = new ArrayList();
        dm.fetchDatanodes(live, null, false);
        long capacity = 0L;
        for (DatanodeDescriptor dn : live) {
            capacity += dn.getCapacity();
        }
        return capacity;
    }

    public static long getDatanodeCapacity(DatanodeManager dm, int index) {
        ArrayList live = new ArrayList();
        dm.fetchDatanodes(live, null, false);
        return ((DatanodeDescriptor)live.get(index)).getCapacity();
    }

    public static void waitForDatanodeStatus(DatanodeManager dm, int expectedLive, int expectedDead, long expectedVolFails, long expectedTotalCapacity, long timeout) throws InterruptedException, TimeoutException {
        ArrayList live = new ArrayList();
        ArrayList dead = new ArrayList();
        int ATTEMPTS = 10;
        int count = 0;
        long currTotalCapacity = 0L;
        int volFails = 0;
        do {
            Thread.sleep(timeout);
            live.clear();
            dead.clear();
            dm.fetchDatanodes(live, dead, false);
            currTotalCapacity = 0L;
            volFails = 0;
            for (DatanodeDescriptor dd : live) {
                currTotalCapacity += dd.getCapacity();
                volFails += dd.getVolumeFailures();
            }
        } while ((expectedLive != live.size() || expectedDead != dead.size() || expectedTotalCapacity != currTotalCapacity || expectedVolFails != (long)volFails) && ++count < 10);
        if (count == 10) {
            throw new TimeoutException("Timed out waiting for capacity. Live = " + live.size() + " Expected = " + expectedLive + " Dead = " + dead.size() + " Expected = " + expectedDead + " Total capacity = " + currTotalCapacity + " Expected = " + expectedTotalCapacity + " Vol Fails = " + volFails + " Expected = " + expectedVolFails);
        }
    }

    public static void waitForDatanodeDeath(DataNode dn) throws InterruptedException, TimeoutException {
        int ATTEMPTS = 10;
        int count = 0;
        do {
            Thread.sleep(1000L);
        } while (dn.isDatanodeUp() && ++count < 10);
        if (count == 10) {
            throw new TimeoutException("Timed out waiting for DN to die");
        }
    }

    public String[] getFileNames(String topDir) {
        if (this.nFiles == 0) {
            return new String[0];
        }
        String[] fileNames = new String[this.nFiles];
        for (int idx = 0; idx < this.nFiles; ++idx) {
            fileNames[idx] = topDir + "/" + this.files[idx].getName();
        }
        return fileNames;
    }

    public static void waitReplication(FileSystem fs, Path fileName, short replFactor) throws IOException {
        boolean good;
        do {
            good = true;
            BlockLocation[] locs = fs.getFileBlockLocations(fs.getFileStatus(fileName), 0L, Long.MAX_VALUE);
            for (int j = 0; j < locs.length; ++j) {
                String[] hostnames = locs[j].getNames();
                if (hostnames.length == replFactor) continue;
                String hostNameList = "";
                for (String h : hostnames) {
                    hostNameList = hostNameList + h + " ";
                }
                System.out.println("Block " + j + " of file " + fileName + " has replication factor " + hostnames.length + "; locations " + hostNameList);
                good = false;
                try {
                    System.out.println("Waiting for replication factor to drain");
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
                break;
            }
            if (!good) continue;
            System.out.println("All blocks of file " + fileName + " verified to have replication factor " + replFactor);
        } while (!good);
    }

    public void cleanup(FileSystem fs, String topdir) throws IOException {
        Path root = new Path(topdir);
        fs.delete(root, true);
        this.files = null;
    }

    public static ExtendedBlock getFirstBlock(FileSystem fs, Path path) throws IOException {
        DFSClient.DFSDataInputStream in = (DFSClient.DFSDataInputStream)((DistributedFileSystem)fs).open(path);
        in.readByte();
        return in.getCurrentBlock();
    }

    public static List<LocatedBlock> getAllBlocks(FSDataInputStream in) throws IOException {
        return ((DFSClient.DFSDataInputStream)in).getAllBlocks();
    }

    public static Token<BlockTokenIdentifier> getBlockToken(FSDataOutputStream out) {
        return ((DFSOutputStream)out.getWrappedStream()).getBlockToken();
    }

    static void setLogLevel2All(Log log) {
        ((Log4JLogger)log).getLogger().setLevel(Level.ALL);
    }

    public static String readFile(File f) throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        BufferedReader in = new BufferedReader(new FileReader(f));
        while ((c = in.read()) != -1) {
            b.append((char)c);
        }
        in.close();
        return b.toString();
    }

    public static void writeFile(FileSystem fs, Path p, String s) throws IOException {
        if (fs.exists(p)) {
            fs.delete(p, true);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        FSDataOutputStream os = fs.create(p);
        IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)s.length(), (boolean)true);
    }

    public static void appendFile(FileSystem fs, Path p, String s) throws IOException {
        assert (fs.exists(p));
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        FSDataOutputStream os = fs.append(p);
        IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)s.length(), (boolean)true);
    }

    public static String urlGet(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)conn.getInputStream(), (OutputStream)out, (int)4096, (boolean)true);
        return out.toString();
    }

    public static void updateConfWithFakeGroupMapping(Configuration conf, Map<String, String[]> map) {
        if (map != null) {
            MockUnixGroupsMapping.fakeUser2GroupsMap = map;
        }
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, ShellBasedUnixGroupsMapping.class);
    }

    public static FileSystem getFileSystemAs(UserGroupInformation ugi, final Configuration conf) throws IOException, InterruptedException {
        return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((Configuration)conf);
            }
        });
    }

    public static byte[] generateSequentialBytes(int start, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)((start + i) % 127);
        }
        return result;
    }

    public static FileSystem.Statistics getStatistics(FileSystem fs) {
        return FileSystem.getStatistics((String)fs.getUri().getScheme(), fs.getClass());
    }

    public static byte[] loadFile(String filename) throws IOException {
        File file = new File(filename);
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        byte[] content = new byte[(int)file.length()];
        in.readFully(content);
        return content;
    }

    public static DataTransferProtos.BlockOpResponseProto transferRbw(ExtendedBlock b, DFSClient dfsClient, DatanodeInfo ... datanodes) throws IOException {
        Assert.assertEquals((long)2L, (long)datanodes.length);
        Socket s = DFSOutputStream.createSocketForPipeline((DatanodeInfo)datanodes[0], (int)datanodes.length, (DFSClient)dfsClient);
        long writeTimeout = dfsClient.getDatanodeWriteTimeout(datanodes.length);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(NetUtils.getOutputStream((Socket)s, (long)writeTimeout), HdfsConstants.SMALL_BUFFER_SIZE));
        DataInputStream in = new DataInputStream((InputStream)NetUtils.getInputStream((Socket)s));
        new Sender(out).transferBlock(b, new Token(), dfsClient.clientName, new DatanodeInfo[]{datanodes[1]});
        out.flush();
        return DataTransferProtos.BlockOpResponseProto.parseDelimitedFrom((InputStream)in);
    }

    static class MockUnixGroupsMapping
    extends ShellBasedUnixGroupsMapping {
        static Map<String, String[]> fakeUser2GroupsMap;
        private static final List<String> defaultGroups;

        MockUnixGroupsMapping() {
        }

        public List<String> getGroups(String user) throws IOException {
            boolean found = false;
            List<String> l = new ArrayList<String>();
            for (String u : fakeUser2GroupsMap.keySet()) {
                if (!user.equals(u)) continue;
                found = true;
                for (String gr : fakeUser2GroupsMap.get(u)) {
                    l.add(gr);
                }
            }
            if (!found && (l = super.getGroups(user)).size() == 0) {
                System.out.println("failed to get real group for " + user + "; using default");
                return defaultGroups;
            }
            return l;
        }

        static {
            defaultGroups = new ArrayList<String>(1);
            defaultGroups.add("supergroup");
            fakeUser2GroupsMap = new HashMap<String, String[]>();
        }
    }

    private class MyFile {
        private String name = "";
        private int size;
        private long seed;

        MyFile() {
            int nLevels = gen.nextInt(DFSTestUtil.this.maxLevels);
            if (nLevels != 0) {
                int[] levels = new int[nLevels];
                for (int idx = 0; idx < nLevels; ++idx) {
                    levels[idx] = gen.nextInt(10);
                }
                StringBuffer sb = new StringBuffer();
                for (int idx = 0; idx < nLevels; ++idx) {
                    sb.append(dirNames[levels[idx]]);
                    sb.append("/");
                }
                this.name = sb.toString();
            }
            long fidx = -1L;
            while (fidx < 0L) {
                fidx = gen.nextLong();
            }
            this.name = this.name + Long.toString(fidx);
            this.size = DFSTestUtil.this.minSize + gen.nextInt(DFSTestUtil.this.maxSize - DFSTestUtil.this.minSize);
            this.seed = gen.nextLong();
        }

        String getName() {
            return this.name;
        }

        int getSize() {
            return this.size;
        }

        long getSeed() {
            return this.seed;
        }
    }
}

